/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <list>
#include <algorithm>
#include <iterator>
#include "print.hpp"
using namespace std;

class IntSequence {
  private:
    int value;
  public:
    IntSequence (int initialValue) // konstruktor
     : value(initialValue) {
    }

    int operator() () {  // "wywolanie funkcji"
        return ++value;
    }
};

int main()
{
    list<int> coll;

    // wstaw wartosci od 1 do 9
    generate_n (back_inserter(coll),    // poczatek
                9,                      // liczba elementow
                IntSequence(1));        // generuje wartosci, począwszy od 1

    PRINT_ELEMENTS(coll);

    // zastap elementy od drugiego do przedostatniego wartosciami poczawszy od 42
    generate (next(coll.begin()),       // poczatek
              prev(coll.end()),         // koniec
              IntSequence(42));         // generuje wartosci

    PRINT_ELEMENTS(coll);
}

