/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <set>
#include "print.hpp"
using namespace std;

// typ dla kryterium sortowania
class RuntimeCmp {
  public:
    enum cmp_mode {normal, reverse};
  private:
    cmp_mode mode;
  public:  
    // konstruktor dla kryterium sortowania
    // - kryterium domyślne wykorzystuje wartość normal
    RuntimeCmp (cmp_mode m=normal) : mode(m) {
    }
    // porównanie elementów
    // - funkcja składowa dla dowolnego typu elementów
    template <typename T>
    bool operator() (const T& t1, const T& t2) const {
        return mode==normal ?  t1<t2
                            :  t2<t1;
    }
    // porównanie kryteriów sortowania
    bool operator== (const RuntimeCmp& rc) const {
        return mode == rc.mode;
    }
};

// typ zbioru wykorzystującego to kryterium sortowania
typedef set<int,RuntimeCmp> IntSet;

int main()
{
    // utwórz, wypełnij i wyświetl zbiór o normalnej kolejności elementów
    // - wykorzystuje domyślne kryterium sortowania
    IntSet coll1 = { 4, 7, 5, 1, 6, 2, 5 };
    PRINT_ELEMENTS (coll1, "coll1: ");

    // utwórz kryterium sortowania o odwrotnej kolejności elementów
    RuntimeCmp reverse_order(RuntimeCmp::reverse);

    // utwórz, wypełnij i wyświetl zbiór o odwrotnej kolejności elementów
    IntSet coll2(reverse_order);
    coll2 = { 4, 7, 5, 1, 6, 2, 5 };
    PRINT_ELEMENTS (coll2, "coll2: ");

    // przypisz elementy ORAZ kryterium sortowania
    coll1 = coll2;
    coll1.insert(3);
    PRINT_ELEMENTS (coll1, "coll1: ");

    // tylko dla upewnienia się...
    if (coll1.value_comp() == coll2.value_comp()) {
        cout << "zbiory coll1 oraz coll2 posiadaja to samo kryterium sortowania"
             << endl;
    }
    else {
        cout << "zbiory coll1 oraz coll2 posiadaja rozne kryteria sortowania"
             << endl;
    }
}

