/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <set>
#include <algorithm>
#include <iterator>
using namespace std;

int main()
{
    // typ kolekcji:
    // - brak powtórzeń
    // - elementy są wartościami całkowitymi
    // - porządek malejący
    set<int,greater<int>> coll1;

    // wstaw elementy w przypadkowej kolejności, używając różnych wersji funkcji składowych
    coll1.insert({4,3,5,1,6,2});
    coll1.insert(5);

    // iteruj po wszystkich elementach i wypisz je
    for (int elem : coll1) {
        cout << elem << ' ';
    }
    cout << endl;

    // wstaw ponownie wartość 4 i przetwórz wartość zwracaną
    auto status = coll1.insert(4);
    if (status.second) {
        cout << "wartosc 4 wstawiono jako element "
             << distance(coll1.begin(),status.first) + 1 << endl;
    }
    else {
        cout << "element 4 juz istnieje" << endl;
    }

    // przypisz elementy do innego zbioru o porządku rosnącym
    set<int> coll2(coll1.cbegin(),coll1.cend());
    
    // wypisz wszystkie elementy kopii używając iteratora strumieniowego
    copy (coll2.cbegin(), coll2.cend(),
          ostream_iterator<int>(cout," "));
    cout << endl;

    // usuń wszystkie elementy aż do elementu o wartości 3
    coll2.erase (coll2.begin(), coll2.find(3));

    // usuń wszystkie elementy o wartości 5
    int num;
    num = coll2.erase (5);
    cout << "usunieto " << num << " element(-y)" << endl;

    // wypisz wszystkie elementy
    copy (coll2.cbegin(), coll2.cend(),
          ostream_iterator<int>(cout," "));
    cout << endl;
}
