/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <set>
#include <algorithm>
#include <iterator>
using namespace std;

int main()
{
    // typ kolekcji:
    // - dozwolone duplikaty elementów
    // - elementy są wartościami całkowitymi
    // - w kolejności malejącej
    multiset<int,greater<int>> coll1;

    // wstaw elementy w losowej kolejności za pomocą różnych funkcji składowych
    coll1.insert({4,3,5,1,6,2});
    coll1.insert(5);

    // wypisz wszystkie elementy
    for (int elem : coll1) {
        cout << elem << ' ';
    }
    cout << endl;

    // ponownie wstaw element 4 i przetwórz wartość zwracaną
    auto ipos = coll1.insert(4);
    cout << "4 wstawione na pozycji "
         << distance(coll1.begin(),ipos) + 1 << endl;

    // przepisz elementy do innego wielozbioru, w kolejności rosnącej
    multiset<int> coll2(coll1.cbegin(),coll1.cend());
    
    // wypisz wszystkie elementy kopii za pomocą iteratora strumienia wyjściowego
    copy (coll2.cbegin(), coll2.cend(),
          ostream_iterator<int>(cout," "));
    cout << endl;

    // usuń elementy aż do elementu o wartości 3
    coll2.erase (coll2.begin(), coll2.find(3));

    // usuń elementy o wartości 5
    int num;
    num = coll2.erase (5);
    cout << "usunięto " << num << " elementów" << endl;

    // wypisz wszystkie elementy
    copy (coll2.cbegin(), coll2.cend(),
          ostream_iterator<int>(cout," "));
    cout << endl;
}
