/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <deque>
#include <string>
#include <algorithm>
#include <iterator>
using namespace std;

int main()
{
    // utwórz pustą kolejkę deque na łańcuchy
    deque<string> coll;

    // wstaw kilka elementów
    coll.assign (3, string("łańcuch"));
    coll.push_back ("ostatni łańcuch");
    coll.push_front ("pierwszy łańcuch");

    // wypisz elementy w oddzielnych wierszach
    copy (coll.cbegin(), coll.cend(),
          ostream_iterator<string>(cout,"\n"));
    cout << endl;

    // usuń pierwszy i ostatni element
    coll.pop_front();
    coll.pop_back();

    // wstaw łańcuch "inny" do każdego elementu oprócz pierwszego
    for (unsigned i=1; i<coll.size(); ++i) {
        coll[i] = "inny " + coll[i];
    }

    // zmień rozmiar na 4 elementy
    coll.resize (4, "łańcuch zmiany rozmiaru");

    // wypisz elementy w oddzielnych wierszach
    copy (coll.cbegin(), coll.cend(),
          ostream_iterator<string>(cout,"\n"));
}

