/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <thread>
#include <chrono>
#include <random>
#include <iostream>
#include <exception>
using namespace std;

void doSomething (int num, char c)
{
    try {
        // generator liczb losowych (wykorzystuje c jako ziarno do uzyskania różnych sekwencji)
        default_random_engine dre(42*c);
        uniform_int_distribution<int> id(10,1000);
        for (int i=0; i<num; ++i) {
            this_thread::sleep_for(chrono::milliseconds(id(dre)));
            cout.put(c).flush();
            ///...
        }
    }
    // upewniamy się, czy żaden wyjątek nie opuścił wątku, co spowodowałoby zakończenie działania programu
    catch (const exception& e) {
        cerr << "WYJĄTEK WĄTKU (wątek "
             << this_thread::get_id() << "): " << e.what() << endl;
    }
    catch (...) {
        cerr << "WYJĄTEK WĄTKU (wątek "
             << this_thread::get_id() << ")" << endl;
    }
}

int main()
{
    try {
        thread t1(doSomething,5,'.'); // wyświetlenie pięciu kropek w osobnym wątku
        cout << "- uruchomiono wątek pp" << t1.get_id() << endl;

        // wyświetlenie innych znaków w wątkach działających w tle
        for (int i=0; i<5; ++i) {
            thread t(doSomething,10,'a'+i); // wyświetlenie 10 znaków w osobnym wątku
            cout << "- odłączenie uruchomionego wątku dp" << t.get_id() << endl;
            t.detach(); // odłączenie wątku do drugiego planu
    }

        cin.get(); // oczekiwanie na wejście (zwrócenie sterowania)
        cout << "- podłączenie wątku pp" << t1.get_id() << endl;
        t1.join(); // oczekiwanie na zakończenie wątku t1 
    }
    catch (const exception& e) {
       cerr << "WYJĄTEK: " << e.what() << endl;
    }
}

