/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <future>
#include <thread>
#include <iostream>
#include <exception>
#include <stdexcept>
using namespace std;

int queryNumber ()
{
    // odczytanie liczby
    cout << "wprowadź liczbę: ";
    int num;
   cin >> num;

    // zgłoszenie wyjątku, jeśli nie wprowadzono liczby
    if (!cin) {
        throw runtime_error("nie wprowadzono liczby");
    }

    return num;
}

void doSomething (char c, shared_future<int> f)
{
    try {
        // oczekiwanie na wyświetlenie kilku znaków
        int num = f.get(); // pobranie wyniku funkcji of queryNumber()

        for (int i=0; i<num; ++i) {
            this_thread::sleep_for(chrono::milliseconds(100));
            cout.put(c).flush();
        }
    }
    catch (const exception& e) {
        cerr << "WYJĄTEK w wątku " << this_thread::get_id()
                  << ": " << e.what() << endl;
    }
}

int main()
{
    try {
        // uruchomienie wątku w celu zapytania o liczbę
        shared_future<int> f = async(queryNumber);

        // uruchomienie trzech wątków — każdy przetwarza tę liczbę w pętli
        auto f1 = async(launch::async,doSomething,'.',f);
        auto f2 = async(launch::async,doSomething,'+',f);
        auto f3 = async(launch::async,doSomething,'*',f);

        // oczekiwanie na zakończenie wszystkich pętli
        f1.get();
        f2.get();
        f3.get();
    }
    catch (const exception& e) {
        cout << "\nWYJĄTEK: " << e.what() << endl;
    }
    cout << "\nzrobione" << endl;
}

