/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include "algostuff.hpp"
using namespace std;

int main()
{
    vector<int> coll;

    INSERT_ELEMENTS(coll,1,9);
    PRINT_ELEMENTS(coll,"coll:            ");

    // przesun cyklicznie jeden element w lewo
    rotate (coll.begin(),      // poczatek zakresu
            coll.begin() + 1,  // nowy pierwszy element
            coll.end());       // koniec zakresu
    PRINT_ELEMENTS(coll,"jeden w lewo:    ");

    // przesun cyklicznie dwa elementy w prawo
    rotate (coll.begin(),      // poczatek zakresu
            coll.end() - 2,    // nowy pierwszy element
            coll.end());       // koniec zakresu
    PRINT_ELEMENTS(coll,"dwa w prawo:     ");

    // przesun cyklicznie tak, zeby poczatkiem byl element o wartosci 4
    rotate (coll.begin(),                     // poczatek zakresu
            find(coll.begin(),coll.end(),4),  // nowy pierwszy element
            coll.end());                      // koniec zakresu
    PRINT_ELEMENTS(coll,"4-ka pierwsza:   ");
}
