/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include "algostuff.hpp"
using namespace std;

int main()
{
    vector<int> coll1 = { 1, 1, 2, 3, 4, 5, 6, 7, 8, 9 };
    PRINT_ELEMENTS(coll1,"coll1: ");

    // sprawdź czy coll1 jest posortowany
    if (is_sorted (coll1.begin(), coll1.end())) {
        cout << "coll1 jest posortowany" << endl;
    }
    else {
        cout << "coll1 nie jest posortowany" << endl;
    }

    map<int,string> coll2;
    coll2 = { {1,"Bill"}, {2,"Jim"}, {3,"Nico"}, {4,"Liu"}, {5,"Ai"} };
    PRINT_MAPPED_ELEMENTS(coll2,"coll2: ");

    // predykat do porównywania imion
    auto compareName = [](const pair<int,string>& e1,
                          const pair<int,string>& e2){
                            return e1.second<e2.second;
                       };

    // sprawdź, czy imiona w coll2 są posortowane
    if (is_sorted (coll2.cbegin(), coll2.cend(),
                   compareName)) {
        cout << "imiona w coll2 są posortowane" << endl;
    }
    else {
        cout << "imiona w coll2 nie są posortowane" << endl;
    }

    // wypisz pierwsze imię naruszające sortowanie coll2
    auto pos = is_sorted_until (coll2.cbegin(), coll2.cend(),
                                compareName);
    if (pos != coll2.end()) {
        cout << "pierwsze nieposortowane imię: " << pos->second << endl;
    }
}
