/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include "algostuff.hpp"
using namespace std;
using namespace std::placeholders;

int main()
{
    vector<int> coll;
    vector<int>::iterator pos;

    INSERT_ELEMENTS(coll,1,9);
    PRINT_ELEMENTS(coll,"coll: ");

    // znajdź pierwszy element większy od 3
    pos = find_if (coll.begin(), coll.end(),    // zakres
                   bind(greater<int>(),_1,3));  // kryterium

    // wypisz jego pozycję
    cout << "pierwszym elementem większym od 3 jest "
         << distance(coll.begin(),pos) + 1
         << ". element" << endl;

    // znajdź pierwszy element podzielny przez 3
    pos = find_if (coll.begin(), coll.end(),
                   [](int elem){
                       return elem%3==0;
                   });

    // wypisz jego pozycję
    cout << "pierwszym elementem podzielnym przez 3 jest "
         << distance(coll.begin(),pos) + 1
         << ". element" << endl;

    // znajdź pierwszy element nie <5
    pos = find_if_not (coll.begin(), coll.end(),
                       bind(less<int>(),_1,5));
    cout << "pierwszym elementem nie mniejszym od 5 jest " << *pos << ". element" << endl;
}
