/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <algorithm>
#include <iterator>
#include <list>
#include <iostream>
using namespace std;

int main()
{
    list<int> coll;

    // wstaw elementy od 6 do 1 oraz od 1 do 6
    for (int i=1; i<=6; ++i) {
        coll.push_front(i);
        coll.push_back(i);
    }

    // wypisz wszystkie elementy kolekcji
    copy (coll.cbegin(), coll.cend(),
          ostream_iterator<int>(cout," "));
    cout << endl;

    // usuń wszystkie elementy o wartości 3
    // - zachowaj nową pozycję końca
    list<int>::iterator end = remove (coll.begin(), coll.end(),
                                      3);

    // wypisz wynikowe elementy kolekcji
    copy (coll.begin(), end,
          ostream_iterator<int>(cout," "));
    cout << endl;

    // wypisz liczbę elementów usuniętych
    cout << "liczba usuniętych elementów: "
         << distance(end,coll.end()) << endl;

    // usuń 'usunięte' elementy
    coll.erase (end, coll.end());

    // wypisz wszystkie elementy zmodyfikowanej kolekcji
    copy (coll.cbegin(), coll.cend(),
          ostream_iterator<int>(cout," "));
    cout << endl;
}
