/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <string>       // dla łańcuchów znakowych
#include <iostream>     // dla operacji wejścia-wyjścia
#include <fstream>      // dla operacji wejścia-wyjścia na plikach
#include <iomanip>      // dla setw()
#include <cstdlib>      // dla exit()
using namespace std;

// deklaracje zapowiadające
void writeCharsetToFile (const string& filename);
void outputFile (const string& filename);

int main ()
{
    writeCharsetToFile("charset.out");
    outputFile("charset.out");
}

void writeCharsetToFile (const string& filename)
{
    // otwórz plik wyjściowy
    ofstream file(filename);

    // czy plik został otworzony prawidłowo?
    if (! file) {
        // NIE, przerwij działanie programu
        cerr << "nie mogę otworzyć pliku wyjściowego \"" << filename << "\""
             << endl;
        exit(EXIT_FAILURE);
    }

    // zapisz zestaw znaków
    for (int i=32; i<256; ++i) {
        file << "wartośc: " << setw(3) << i << "   "
             << "znak:  " << static_cast<char>(i) << endl;
    }

}   // plik zostanie zamknięty automatycznie

void outputFile (const string& filename)
{
    // otwórz plik wejściowy
    ifstream file(filename);

    // czy plik został otworzony prawidłowo?
    if (! file) {
        // NIE, przerwij działanie programu
        cerr << "nie mogę otworzyć pliku wejściowego \"" << filename << "\""
             << endl;
        exit(EXIT_FAILURE);
    }

    // przekopiuj zawartośc do strumienia cout
    char c;
    while (file.get(c)) {
        cout.put(c);
    }

}   // plik zostanie zamknięty automatycznie

