/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <string>
#include <exception>
#include "Queue.hpp"      // use special queue class
using namespace std;

int main()
{
   try {    
      Queue<string> q;

      // wstawia do kolejki trzy elementy
      q.push("To ");
      q.push("są ");
      q.push("więcej niż ");

      // odczytuje z kolejki dwa elementy i je wypisuje
      cout << q.pop();
      cout << q.pop();

      // wstawia dwa nowe elementy
      q.push("cztery ");
      q.push("słowa!");

      // pomija jeden element
      q.pop();

      // odczytuje i wypisuje dwa elementy z kolejki
      cout << q.pop();
      cout << q.pop() << endl;

      // wypisuje liczbę elementów w kolejce
      cout << "liczba elementów w kolejce: " << q.size()
           << endl;

      // odczytanie i wypisanie jednego elementu
      cout << q.pop() << endl;
   }
   catch (const exception& e) {
      cerr << "WYJĄTEK: " << e.what() << endl;
   }
}
