/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <bitset>
#include <iostream>
using namespace std;

int main()
{
    // typ wyliczeniowy używany w klasie bitset
    // - każdy bit reprezentuje kolor
    enum Color { red, yellow, green, blue, white, black, /*...,*/
                 numColors };
    // tworzy kontener bitset dla wszystkich bitów (kolorów)
    bitset<numColors> usedColors;

    // ustawia bity dla dwóch kolorów
    usedColors.set(red);
    usedColors.set(blue);

    // wypisuje informacje o niektorych danych przechowywanych
    // w klasie bitset
    cout << "wartości bitowe użytych kolorów:   " << usedColors
         << endl;
    cout << "liczba użytych kolorów:   " << usedColors.count()
         << endl;
    cout << "wartości bitowe niewykorzystanych kolorów: " << ~usedColors
         << endl;

    // jeśli został wykorzystany jakikolwiek kolor
    if (usedColors.any()) {
        // przejrzyj wszystkie kolory
        for (int c = 0; c < numColors; ++c) {
            // jeśli wykorzystany został rzeczywisty kolor
            if (usedColors[(Color)c]) {
                //...
            }
        }
    }
}
