/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <cstdlib>
#include "algostuff.hpp"
using namespace std;

bool absLess (int elem1, int elem2)
{
    return abs(elem1) < abs(elem2);
}

int main()
{
    deque<int> coll;

    INSERT_ELEMENTS(coll,2,6);
    INSERT_ELEMENTS(coll,-3,6);

    PRINT_ELEMENTS(coll);

    // znajdź i wypisz minimum i maksimum
    cout << "minimum:  "
         << *min_element(coll.cbegin(),coll.cend())
         << endl;
    cout << "maksimum: "
         << *max_element(coll.cbegin(),coll.cend())
         << endl;

    // wypisanie najmniejszej i największej wartości, i odległości między nimi na bazie minmax_element()
    auto mm = minmax_element(coll.cbegin(),coll.cend());
    cout << "minimum:  " << *(mm.first) << endl;    // wypisz minimum
    cout << "maksimum: " << *(mm.second) << endl;   // wypisz maksimum
    cout << "odstęp:   " << distance(mm.first,mm.second) << endl;

    // znajdź i wypisz minimum i maksimum wartości bezwzględnych
    cout << "minimum wartości bezwzględnych:  "
         << *min_element(coll.cbegin(),coll.cend(),
                         absLess)
         << endl;
    cout << "maksimum wartości bezwzględnych: "
         << *max_element(coll.cbegin(),coll.cend(),
                         absLess)
         << endl;
}
