/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include "algostuff.hpp"
using namespace std;

int main()
{
    vector<int> coll;

    INSERT_ELEMENTS(coll,3,7);
    INSERT_ELEMENTS(coll,5,9);
    INSERT_ELEMENTS(coll,1,4);

    PRINT_ELEMENTS (coll, "poczatkowo:      ");

    // konwertuj kolekcje na stog
    make_heap (coll.begin(), coll.end());

    PRINT_ELEMENTS (coll, "po make_heap():  ");

    // zdejmij ze stogu nastepny element
    pop_heap (coll.begin(), coll.end());
    coll.pop_back();

    PRINT_ELEMENTS (coll, "po pop_heap():   ");

    // poloz na stog nowy element
    coll.push_back (17);
    push_heap (coll.begin(), coll.end());

    PRINT_ELEMENTS (coll, "po push_heap():  ");

    // konwertuj stog na posortowana kolekcje
    // - UWAGA: po tym wywolaniu nie jest to juz stog
    sort_heap (coll.begin(), coll.end());

    PRINT_ELEMENTS (coll, "po sort_heap():  ");
}
