/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include "algostuff.hpp"
using namespace std;

int main()
{
    deque<int> coll;
    list<int> subcoll;

    INSERT_ELEMENTS(coll,1,7);
    INSERT_ELEMENTS(coll,1,7);

    INSERT_ELEMENTS(subcoll,3,6);

    PRINT_ELEMENTS(coll,   "coll:    ");
    PRINT_ELEMENTS(subcoll,"subcoll: ");

    // szukaj ostatniego wystapienia ciagu subcoll w kolekcji coll
    deque<int>::iterator pos;
    pos = find_end (coll.begin(), coll.end(),         // zakres
                    subcoll.begin(), subcoll.end());  // podzakres

    // wykonuj petle tak dlugo, jak dlugo ciag subcoll znajdowany jest jako podzakres kolekcji coll
    deque<int>::iterator end(coll.end());
    while (pos != end) { 
        // wypisz pozycje pierwszego elementu
        cout << "znaleziono ciag subcoll wystepujacy na pozycjach poczawszy od elementu "
             << distance(coll.begin(),pos) + 1
             << endl;

        // szukaj nastepnego wystapienia ciagu subcoll
        end = pos;
        pos = find_end (coll.begin(), end,               // zakres
                        subcoll.begin(), subcoll.end()); // podzakres
    }
}
