/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <chrono>
#include <ctime>
#include <string>

// konwertuj punkt w czasie zegara systemowego na łańcuch czasu kalendarzowego
inline
std::string asString (const std::chrono::system_clock::time_point& tp)
{
    // konwersja na czas systemowy:
    std::time_t t = std::chrono::system_clock::to_time_t(tp);
    std::string ts = ctime(&t);    // konwertuj na czas kalendarzowy
    ts.resize(ts.size()-1);        // wytnij znak nowego wiersza z końca
    return ts; 
}

// konwertuj czas kalendarzowy na punkt w czasie zegara systemowego
inline
std::chrono::system_clock::time_point
makeTimePoint (int year, int mon, int day,
               int hour, int min, int sec=0)
{
    struct std::tm t;
    t.tm_sec = sec;        // sekunda w minucie (0 .. 59, ew. 60 dla sekund przestępnych)
    t.tm_min = min;        // minuta w godzinie (0 .. 59)
    t.tm_hour = hour;      // godzina w dniu (0 .. 23)
    t.tm_mday = day;       // dzień w miesiącu (1 .. 31)
    t.tm_mon = mon-1;      // miesiąc w roku (0 .. 11)
    t.tm_year = year-1900; // rok, liczony od 1900
    t.tm_isdst = -1;       // sprawdź, czy czas lokalny jest czasem letnim
    std::time_t tt = std::mktime(&t);
    if (tt == -1) {
        throw "brak poprawnego czasu systemowego";
    }
    return std::chrono::system_clock::from_time_t(tt);
}
