/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <string>
#include <regex>
#include <iostream>
#include <algorithm>
using namespace std;

int main()
{
    string data = "<osoba>\n"
                  " <imie>Nico</imie>\n"
                  " <nazwisko>Jankowski</nazwisko>\n"
                  "</osoba>\n";

    regex reg("<(.*)>(.*)</(\\1)>");

    // iterowanie po wszystkich dopasowaniach (z wykorzystaniem iteratorów regex_iterator):
    sregex_iterator pos(data.cbegin(),data.cend(),reg);
    sregex_iterator end;
    for ( ; pos!=end ; ++pos ) {
        cout << "dopasowanie: " << pos->str() << endl;
        cout << " znacznik: " << pos->str(1) << endl;
        cout << " wartość: " << pos->str(2) << endl;
    }

    // wykorzystanie iteratora regex_iterator w celu przetwarzania wszystkich dopasowanych podciągów jako elementów w algorytmie: 
    sregex_iterator beg(data.cbegin(),data.cend(),reg);
    for_each (beg,end,[](const smatch& m) {
                          cout << "dopasowanie: " << m.str() << endl;
                          cout << " znacznik: " << m.str(1) << endl;
                          cout << " wartość: " << m.str(2) << endl;
                      });
}
