/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <iomanip>
#include <chrono>
#include <ctime>
#include <cstdlib>
using namespace std;

int main ()
{
    // przetworzenie i wypisanie bieżącej daty i godziny:
    auto now = chrono::system_clock::now();
    time_t t = chrono::system_clock::to_time_t(now);
    tm* nowTM = localtime(&t);
    cout << put_time(nowTM,"data: %x\ngodzina: %X\n") << endl;

    // wczytanie daty/godziny:
    tm* date;
    cout << "nowa data: ";
    cin >> get_time(date,"%x"); // wczytanie daty z wejścia
    if (!cin) {
        cerr << "niepoprawny format danych" << endl;
    }
}

