/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <sstream>
#include <bitset>
using namespace std;

int main()
{
    ostringstream os;

    // wartość dziesiętna oraz szesnastkowa
    os << "dziesiętnie: " << 15 << hex << " szesnastkowo: " << 15 << endl;
    cout << os.str() << endl;

    // dołącz wartość rzeczywistą oraz pole bitowe
    bitset<15> b(5789);
    os << "float: " << 4.67 << " bitset: " << b << endl;

    // nadpisz wartością ósemkową
    os.seekp(0);
    os << "ósemkowo: " << oct << 15;
    cout << os.str() << endl;
}
