/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include "inbuf1.hpp"

int main()
{
    inbuf ib;                // utwórz specjalny bufor strumienia
    std::istream in(&ib);    // zainicjalizuj przy użyciu tego bufora strumień wejściowy

    char c;
    for (int i=1; i<=20; i++) {
        // odczytaj kolejny znak (koniec bufora)
        in.get(c);

        // wypisz ten znak (i opróżnij bufor)
        std::cout << c << std::flush;

        // po ośmiu znakach umieść dwa znaki w strumieniu
        if (i == 8) {
            in.unget();
            in.unget();
        }
    }
    std::cout << std::endl;
}
