/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <thread>
#include <future>
#include <iostream>
#include <string>
#include <exception>
#include <stdexcept>
#include <functional>
#include <utility>

void doSomething (std::promise<std::string>& p)
{
    try {
        // odczytanie znaku i zgłoszenie wyjątku, jeśli jest to znak 'x'
                std::cout << "wprowadź znak ('x', aby zgłosić wyjątek): ";
        char c = std::cin.get();
        if (c == 'x') {
            throw std::runtime_error(std::string("wczytano znak ")+c);
        }
        // ...
        std::string s = std::string("przetworzono znak ") + c;
        p.set_value(std::move(s)); // zapamiętanie wyniku
    }
    catch (...) {
        p.set_exception(std::current_exception()); // zapamiętanie wyjątku
    }
}

int main()
{
    try {
        // uruchomienie wątku z wykorzystaniem promesy do przechowania wyniku
        std::promise<std::string> p;
        std::thread t(doSomething,std::ref(p));
        t.detach();
        //...

        // utworzenie obiektu futury w celu przetwarzania wyniku
        std::future<std::string> f(p.get_future());

        // przetwarzanie wyniku
        std::cout << "wynik: " << f.get() << std::endl;
    }
    catch (const std::exception& e) {
        std::cerr << "WYJĄTEK: " << e.what() << std::endl;
    }
    catch (...) {
       std::cerr << "WYJĄTEK " << std::endl;
    }
}

