/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include "algostuff.hpp"
using namespace std;
using namespace std::placeholders;

int main()
{
    list<int> coll;

    INSERT_ELEMENTS(coll,2,6);
    INSERT_ELEMENTS(coll,4,9);
    PRINT_ELEMENTS(coll);

    // wypisz wszystkie elementy o wartosci 5 zastapione wartoscia 55
    replace_copy(coll.cbegin(), coll.cend(),         // źródło
                 ostream_iterator<int>(cout," "),    // przeznaczenie
                 5,                                  // stara wartość
                 55);                                // nowa wartość
    cout << endl;

    // wypisz wszystkie elementy o wartosci wiekszej od 5 zastapione wartoscia 42
    replace_copy_if(coll.cbegin(), coll.cend(),      // źródło
                    ostream_iterator<int>(cout," "), // przeznaczenie
                    bind(less<int>(),_1,5),          // kryterium zastąpienia
                    42);                             // nowa wartość
    cout << endl;

    // wypisz kazdy element, przy czym kazdy element nieparzysty zastapiony ma byc wartoscia 0
    replace_copy_if(coll.cbegin(), coll.cend(),      // źródło
                    ostream_iterator<int>(cout," "), // przeznaczenie
                    [](int elem){                    // kryterium zastąpienia
                        return elem%2==1;
                    },
                    0);                              // nowa wartość
    cout << endl;
}
