<?php 
if(!defined('BASEPATH'))
{
	exit('No direct script access allowed');
}

class Edytuj extends CI_Controller 
{
	public function __construct()
	{
		parent::__construct();
		$this->load->model('Edytuj_model');	
		$this->load->model('Wspoldzielone_model');
		$this->load->helper('url');
		$this->load->library('session');
		$this->load->library('form_validation');
		$this->output->enable_profiler(TRUE);
	}
	
	public function wpis($IdWpisu)
	{
		if($this->session->userdata('bloguseradmin') == 'tak')
		{
			$NaglowekDane['tytul'] = 'Edycja wpisu';
			
			$this->load->view('naglowek',$NaglowekDane);
			
			// Kategorie
			$Rezultat = $this->Wspoldzielone_model->ElementyMenu();
		
			$i = 0;
			
			foreach($Rezultat->result() as $Wiersz)
			{
				$GlownaWpisy['kategoria'][$i]['id'] = $Wiersz->blog_id;
				$GlownaWpisy['kategoria'][$i]['nazwa'] = $Wiersz->blog_kategoria;
				
				$i++;
			}
			
			// Edycja treści
			if($this->input->post('edytujwpis') == 'tak')
			{
				$this->form_validation->set_rules('wpis_tytul', 'Tytuł', 'required');
				$this->form_validation->set_rules('wpis_tresc', 'Treść', 'required');
				$this->form_validation->set_rules('wpis_kategoria', 'Kategoria', 'required');
	
				if($this->form_validation->run() != FALSE)
				{
					// Wpis został przeedytowany
					
					$this->Edytuj_model->EdytujBiezacyWpis();
					
					$GlownaWpisy['WpisZostalPrzeedytowany'] = TRUE;
				}
				else
				{
					$GlownaWpisy['WpisZostalPrzeedytowanyBlad'] = TRUE;
				}
			}
			
			// Generowanie treści
			$Rezultat = $this->Edytuj_model->PobierzWpisDoEdycji($IdWpisu);
			
			foreach($Rezultat->result() as $Wiersz)
			{
				$GlownaWpisy['wpisy'][0]['wpis_id'] = $Wiersz->wpis_id;
				$GlownaWpisy['wpisy'][0]['wpis_tytul'] = $Wiersz->wpis_tytul;
				$GlownaWpisy['wpisy'][0]['wpis_tresc'] = $Wiersz->wpis_tresc;
				$GlownaWpisy['wpisy'][0]['wpis_kategoria'] = $Wiersz->wpis_kategoria;
			}
			
			$this->load->view('edycjawpisu',$GlownaWpisy);
			
			$this->load->view('stopka');
		}
		else
		{
			redirect();
		}
	}
	
	public function dodajkategorie()
	{
		if($this->session->userdata('bloguseradmin') == 'tak')
		{
			$NaglowekDane['tytul'] = 'Dodaj kategorię';
			
			$this->load->view('naglowek',$NaglowekDane);
			
			if($this->input->post('dodaj_teraz') == 'tak')
			{
				$this->form_validation->set_rules('blog_kategoria', 'Nazwa kategorii', 'required');
				
				if($this->form_validation->run() != FALSE)
				{
					// Kategoria dodana
					
					$this->Edytuj_model->DodajKategorie();
					
					$KategoriaDane['KategoriaDodana'] = TRUE;
				}
			}
			
			$this->load->view('dodajkategorie',$KategoriaDane);
			
			$this->load->view('stopka');
		}
		else
		{
			redirect();
		}
	}
	
	public function usunkategorie($KategoriaId)
	{
		if($this->session->userdata('bloguseradmin') == 'tak')
		{
			$this->Edytuj_model->UsunKategorie($KategoriaId);
			redirect();	
		}
		else
		{
			redirect();
		}
	}
	
	public function edytujkategorie($KategoriaId)
	{
		if($this->session->userdata('bloguseradmin') == 'tak')
		{
			$NaglowekDane['tytul'] = 'Edytuj kategorię';
			
			$this->load->view('naglowek',$NaglowekDane);
			
			if($this->input->post('edytuj_teraz') == 'tak')
			{
				$this->form_validation->set_rules('blog_kategoria', 'Nazwa kategorii', 'required');
				
				if($this->form_validation->run() != FALSE)
				{
					// Kategoria zaktualizowana
					
					$this->Edytuj_model->AktualizujKategorie();
					
					$KategoriaDane['KategoriaDodana'] = TRUE;
				}
			}
			
			$Rezultat = $this->Edytuj_model->EdytujKategorie($KategoriaId);
			
			foreach($Rezultat->result() as $Wiersz)
			{
				$KategoriaDane['BlogKategoriaNazwa'] = $Wiersz->blog_kategoria;
				$KategoriaDane['BlogKategoriaId'] = $Wiersz->blog_id;
			}
			
			$this->load->view('edytujkategorie',$KategoriaDane);
			
			$this->load->view('stopka');
		}
		else
		{
			redirect();
		}
	}
	
	public function nowywpis()
	{
		if($this->session->userdata('bloguseradmin') == 'tak')
		{
			$NaglowekDane['tytul'] = 'Dodaj nowy wpis na blogu';
			
			$this->load->view('naglowek',$NaglowekDane);
			
			if($this->input->post('dodajterazwpis') == 'tak')
			{
				$this->form_validation->set_rules('wpis_tytul', 'Tytuł', 'required');
				$this->form_validation->set_rules('wpis_tresc', 'Treść', 'required');
				$this->form_validation->set_rules('wpis_kategoria', 'Kategoria', 'required');
	
				if($this->form_validation->run() != FALSE)
				{
					// Nowy wpis dodany
					
					$this->Edytuj_model->DodajNowyWpis();
					
					$GlownaWpisy['WpisZostalDodany'] = TRUE;
				}
			}
			
			// Kategorie
			$Rezultat = $this->Wspoldzielone_model->ElementyMenu();
			
			$i = 0;
			
			foreach($Rezultat->result() as $Wiersz)
			{
				$GlownaWpisy['kategoria'][$i]['id'] = $Wiersz->blog_id;
				$GlownaWpisy['kategoria'][$i]['nazwa'] = $Wiersz->blog_kategoria;
				
				$i++;
			}
			
			$this->load->view('nowywpis',$GlownaWpisy);
			
			$this->load->view('stopka');
		}
		else
		{
			redirect();
		}
	}
	
	public function zmienhaslo()
	{
		if($this->session->userdata('bloguseradmin') == 'tak')
		{
			$NaglowekDane['tytul'] = 'Zmień hasło administratora';
			
			$this->load->view('naglowek',$NaglowekDane);
			
			if($this->input->post('zmienterazhaslo') == 'tak')
			{
				$this->form_validation->set_rules('stare_haslo', 'Stare hasło', 'required|callback_sprawdz_haslo');
				$this->form_validation->set_rules('nowe_haslo', 'Nowe hasło', 'required|callback_sprawdz_zgodnosc');
				$this->form_validation->set_rules('nowe_haslo_pwt', 'Nowe hasło (powtórz)', 'required');

				if($this->form_validation->run() != FALSE)
				{
					// Hasło zostało zaktualizowane
					
					$this->Edytuj_model->ZmienHasloRoota();
					
					$GlownaWpisy['HasloZostaloZaktualizowane'] = TRUE;
				}
			}
			
			$this->load->view('zmienhaslo',$GlownaWpisy);
			
			$this->load->view('stopka');
		}
		else
		{
			redirect();
		}
	}
	
	public function sprawdz_haslo($HasloWFormularzu)
	{
		$Rezultat = $this->Edytuj_model->SprawdzStareHaslo($HasloWFormularzu);
		
		foreach($Rezultat->result() as $Wiersz)
		{
			$IloscPasujacych = $Wiersz->IloscUzytkownikow;
		}
		
		if($IloscPasujacych == 1)
		{
			return TRUE;
		}
		else
		{
			$this->form_validation->set_message('sprawdz_haslo', 'Wpisane przez ciebie stare hasło nie pasuje do zapisanego w bazie danych.');
			return FALSE;
		}
	}
	
	public function sprawdz_zgodnosc()
	{
		if($this->input->post('nowe_haslo') == $this->input->post('nowe_haslo_pwt'))
		{
			return TRUE;
		}
		else
		{
			$this->form_validation->set_message('sprawdz_zgodnosc', 'Nowe hasło i jego powtórzenie nie pasują do siebie.');
			return FALSE;
		}
	}
}
?>