package uk.co.danielbryant.shopping.productcatalogue.model.v2;

import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class BulkPriceTest {
    @Rule
    public ExpectedException onBadData = ExpectedException.none();

    @Test
    public void priceMustBePresent() {
        onBadData.expect(IllegalArgumentException.class);
        onBadData.expectMessage("cena jednostkowa");
        new BulkPrice(null, 2);
    }

    @Test
    public void minimumMustBeAtLeastTwo() {
        // nie "hurtowa", jeśli możemy kupić pojedyncze przedmioty
        onBadData.expect(IllegalArgumentException.class);
        onBadData.expectMessage("minimalna ilość");
        new BulkPrice(new UnitPrice(1), 1);
    }
}
