# Rozdział 14. - Przykłady

Przykłady do rozdziału 14. pt. *Atrybuty* książki *C# 8.0 Programowanie*.

## Stosowanie atrybutów

* [Listing 1. Atrybuty w klasie testu jednostkowego](Atrybuty/ImageManagement.Tests/WhenPropertiesRetrieved.cs)
* [Listing 2. Atrybut z argumentem konstruktora](Atrybuty/ImageManagement.Tests/TestWithAdditionalAttributes.cs#L17-L20)
* [Listing 3. Określanie opcjonalnych ustawień atrybutu przy użyciu właściwości](Atrybuty/ImageManagement.Tests/TestWithAdditionalAttributes.cs#L24-L27)
* [Listing 4. Atrybuty podzespołu umieszczane w pliku AssemblyInfo.cs](Atrybuty/Attributes/AssemblyAttributes.cs#L3-L8)
* [Listing 5. Atrybut modułu](Atrybuty/Attributes/ModuleAttribute.cs)
* [Listing 6. Atrybuty metody oraz wartości wynikowej](Atrybuty/Attributes/InteropAttributes.cs#L7-L9)
* [Listing 7. Atrybut pola zdarzenia](Atrybuty/Attributes/ForCompilerGeneratedMembers.cs#L7-L11)
* [Listing 8. Typowy przykład generowanego pliku z atrybutami podzespołu](Atrybuty/Attributes/TypicalAssemblyAttributes.cs#L4-L25)
* [Listing 9. Atrybuty określające numer wersji](Atrybuty/Attributes/TypicalAssemblyAttributes.cs#L27-L28)
* [Listing 10. Typowe atrybuty zawierające informacje o podzespole](Atrybuty/Attributes/TypicalAssemblyAttributes.cs#L30-L36)
* [Listing 11. Dodawanie do parametrów metod atrybutów informujących o kodzie wywołującym](Atrybuty/Attributes/CallerInfo.cs#L8-L16)
* [Listing 12. INotifyPropertyChanged](Atrybuty/Attributes/NotifyPropertyChanged.cs#L30-L33)
* [Listing 13. Implementacja interfejsu INotifyPropertyChanged nadająca się do wielokrotnego użycia](Atrybuty/Attributes/NotifyPropertyChanged.cs#L6-L25)
* [Listing 14. Zgłaszanie zdarzenia informującego o zmianie wartości właściwości](Atrybuty/Attributes/MyViewModel.cs#L3-L12)
* [Listing 15. InternalsVisibleToAttribute](Atrybuty/Attributes/AssemblyAttributes.cs#L10-L11)
* [Listing 16. Atrybuty związane ze współdziałaniem](Atrybuty/Attributes/InteropAttributes.cs#L11-L16)

## Definiowanie i stosowanie atrybutów niestandardowych

* [Listing 17. Typ atrybutu](Atrybuty/CustomAttributes/PluginInformationAttribute.cs#L5-L19)
* [Listing 18. Stosowanie atrybutu](Atrybuty/CustomAttributes/ReportingPlugin.cs#L6)
* [Listing 19. Określanie wartości opcjonalnej właściwości atrybutu](Atrybuty/CustomAttributes/ReportingPlugin.cs#L11-L12)
* [Listing 20. Interfejs ICustomAttributeProvider](Atrybuty/CustomAttributes/Program.cs#L75-L80)
* [Listing 21. Wyświetlanie informacji o wtyczkach](Atrybuty/CustomAttributes/Program.cs#L20-L40)
* [Listing 22. Pobieranie atrybutów w kontekście przeznaczonym wyłącznie do wykonywania operacji odzwierciedlania](Atrybuty/CustomAttributes/Program.cs#L42-L69)
