﻿using System;
using System.Collections.Generic;

namespace GenericTypes
{
    class Program
    {
        static void Main()
        {
            var a = new NamedContainer<int>(42, "Oto odpowiedź");
            var b = new NamedContainer<int>(99, "Liczba czerwonych balonów");
            var c = new NamedContainer<string>("Programowanie w C#", "Tytuł książki");

            // …gdzie a i b pochodzą z listingu 4.2.
            var namedInts = new List<NamedContainer<int>>() { a, b };
            var namedNamedItem = new NamedContainer<NamedContainer<int>>(a, "Opakowane");

            Show(a);
            Show(b);
            Show(c);

            Show(namedInts);
            Show(namedNamedItem);
        }

        public static void Show<T>(NamedContainer<T> c)
        {
            Console.WriteLine($"{c.Name}: {c.Item}");
        }

        public static void Show<T>(IEnumerable<NamedContainer<T>> cs)
        {
            foreach (NamedContainer<T> c in cs)
            {
                Show(c);
            }
        }
    }
}
