# Rozdział 6. - Przykłady

Przykłady do rozdziału 6. pt. *Dziedziczenie* książki *C# 8.0 Programowanie*.

* [Listing 1. Określanie klasy bazowej](Dziedziczenie/Bases/SpecifyingBase.cs#L9-L16)
* [Listing 2. Łańcuch dziedziczenia](Dziedziczenie/Bases/InheritanceChain.cs#L3-L13)

## Dziedziczenie i konwersje

* [Listing 3. Przykład rzutowania w dół](Dziedziczenie/Bases/Conversions.cs#L5-L10)
* [Listing 4. Zastosowanie operatora as](Dziedziczenie/Bases/Conversions.cs#L12-L20)
* [Listing 5. Wzorzec typu](Dziedziczenie/Bases/TypePattern.cs#L5-L11)
* [Listing 6. Operator is](Dziedziczenie/Bases/Conversions.cs#L24-L27)

## Dziedziczenie interfejsów

* [Listing 7. Dziedziczenie interfejsów](Dziedziczenie/Bases/InterfaceInheritance.cs#L3-L16)
* [Listing 8. Implementacja interfejsu pochodnego](Dziedziczenie/Bases/Impl.cs#L3-L16)

## Typy ogólne

* [Listing 9. Dziedziczenie po ogólnej klasie bazowej](Dziedziczenie/Generics/Program.cs#L13-L34)
* [Listing 10. Argument typu, który musi dziedziczyć po typie w którym został użyty](Dziedziczenie/Generics/Program.cs#L36-L44)
* [Listing 11. Metoda pobierająca dowolny argument typu Base](Dziedziczenie/Generics/Base.cs#L7-L9)
* [Listing 12. Metoda pobierająca argument typu IEnumerable&lt;Base&gt;](Dziedziczenie/Generics/Base.cs#L11-L13)
* [Listing 13. Przekazanie interfejsu IEnumerable&lt;T&gt; typu pochodnego](Dziedziczenie/Generics/Base.cs#L17-L19)
* [Listing 14. Metoda pobierająca argument dowolnego typu ICollection&lt;Base&gt;](Dziedziczenie/Generics/Base.cs#L22-L25)
* [Listing 15. Błąd: próba przekazania interfejsu ICollection&lt;T&gt; typu pochodnego](Dziedziczenie/Generics/Base.cs#L31-L32)
* [Listing 16. Kowariantny parametr typu](Dziedziczenie/Generics/Program.cs#L49)
* [Listing 17. Hierarchia klas definiujących składowe](Dziedziczenie/Generics/ClassHierarchy.cs#L6-L14)
* [Listing 18. Porównywanie kształtów](Dziedziczenie/Generics/ClassHierarchy.cs#L16-L36)
* [Listing 19. Kontrawariantny parametr typu](Dziedziczenie/Generics/Program.cs#L51)
* [Listing 20. Zmiana elementu tablicy](Dziedziczenie/Generics/Base.cs#L36-L39)
* [Listing 21. Przekazywanie tablicy o elementach typu pochodnego](Dziedziczenie/Generics/Base.cs#L43-L44)

## Metody wirtualne

* [Listing 22. Klasa z metodą wirtualną](Dziedziczenie/Virtuals/BaseWithVirtual.cs#L5-L11)
* [Listing 23. Stosowanie metod wirtualnych](Dziedziczenie/Virtuals/Program.cs#L16-L19)
* [Listing 24. Przesłanianie metod wirtualnych](Dziedziczenie/Virtuals/DeriveWithAndWithoutOverride.cs#L5-L15)
* [Listing 25. Wykorzystanie metod wirtualnych](Dziedziczenie/Virtuals/Program.cs#L23-L25)
* [Listing 26. Klasa abstrakcyjna](Dziedziczenie/Virtuals/AbstractBase.cs#L3-L6)
* [Listing 27. Abstrakcyjna implementacja interfejsu](Dziedziczenie/Virtuals/MustBeComparable.cs#L5-L8)
* [Listing 28. Typ bazowy w wersji 1.0](Dziedziczenie/Library1.0/LibraryBase.cs#L3-L5)
* [Listing 29. Klasa pochodna dla biblioteki w wersji 1.0](Dziedziczenie/Virtuals/CustomerDerived.cs#L9-L15)
* [Listing 30. Typ bazowy w wersji 1.1](Dziedziczenie/Library1.1/LibraryBase.cs#L3-L6)
* [Listing 31. Metody ukryte a wirtualne](Dziedziczenie/Virtuals/Program.cs#L9-L13)
* [Listing 32. Unikanie ostrzeżeń podczas ukrywania składowych](Dziedziczenie/Virtuals/CustomerDerived.cs#L17-L23)
* [Listing 33. Ukrywanie w celu zmiany sygnatury](Dziedziczenie/Virtuals/Program.cs#L32-L36)

## Metody i klasy ostateczne

* [Listing 34. Metoda ostateczna](Dziedziczenie/Virtuals/FixedToString.cs#L3-L9)
* [Listing 35. Klasa ostateczna](Dziedziczenie/Virtuals/EndOfTheLine.cs#L3-L5)

## Dostęp do składowych klas bazowych

* [Listing 36. Wywołanie przesłoniętej metody klasy bazowej](Dziedziczenie/Virtuals/CallBase/CustomerDerived.cs#L6-L13)

## Dziedziczenie i tworzenie obiektów

* [Listing 37. Brak domyślnego konstruktora w klasie pochodnej](Dziedziczenie/Construction/Example37/Code.cs#L5-L19)
* [Listing 38. Jawne wywoływanie konstruktora klasy bazowej](Dziedziczenie/Construction/Example38/Code.cs#L5-L26)
* [Listing 39. Określanie kolejności tworzenia obiektów](Dziedziczenie/Construction/Program.cs#L21-L49)
