﻿using Library;

namespace Virtuals
{
    class Program
    {
        static void Main()
        {
            var d = new CustomerDerived();
            LibraryBase b = d;

            d.Start();
            b.Start();
        }

        public static void CallVirtualMethod(BaseWithVirtual o)
        {
            o.ShowMessage();
        }

        public static void ExploitingVirtualMethods()
        {
            CallVirtualMethod(new BaseWithVirtual());
            CallVirtualMethod(new DeriveWithoutOverride());
            CallVirtualMethod(new DeriveAndOverride());
        }
    }

    // Tylko do celów demonstracyjnych - ten typ jest zdefiniowany w .NET 
    // więc nie trzeba go deiniować samemu. W książce pokazałem go jedynie jako przykład
#if false
    public interface ISet<T> : ICollection<T>
    {
        new bool Add(T item);
        // ... pozostałe składowe pominięte w celu skrócenia listingu
    }
#endif
}
