﻿using LibraryContainingCustomComparer;
using System;
using System.Collections.Generic;

namespace Loading
{
    class Program
    {
        static void Main()
        {
            IComparer<string> c = GetComparer(useStandardOrdering: true);

            // Teraz biblioteka LibraryContainingCustomComparer będzie już wczytana, choć nie używany 
            // zdefiniowanego w niej niestandardowego komparatora 

            Console.WriteLine(c.Compare("jabłka", "pomarańcze"));
        }

        static IComparer<string> GetComparer(bool useStandardOrdering)
        {
            if (useStandardOrdering)
            {
                return StringComparer.CurrentCulture;
            }
            else
            {
                return new MyCustomComparer();
            }
        }
    }
}