﻿using System;

namespace FundamentalInterfaces
{
    // Ten przykład przedstawia główne interfejsy Rx. Ponieważ są one zdefiniowane
    // w bibliotece klas .NET, nie trzeba ich definiować samemu. Stąd też użycie dyrektywy #if false
#if false
    public interface IObservable<out T>
    {
        IDisposable Subscribe(IObserver<T> observer);
    }

    public interface IObserver<in T>
    {
        void OnCompleted();
        void OnError(Exception error);
        void OnNext(T value);
    }
#endif

    class Program
    {
        static void Main()
        {
            var source = new SimpleColdSource();
            var sub = new MySubscriber<string>();
            source.Subscribe(sub);
        }

        public static void SubscribeToKeyWatcher()
        {
            var source = new KeyWatcher();
            var sub = new MySubscriber<char>();
            source.Subscribe(sub);
            source.Run();
        }
    }
}