﻿using System;
using System.Collections.Generic;
using System.Linq;

namespace StandardOperators
{
    public static class Grouping
    {
        public static void GroupingQueryExpression()
        {
            var subjectGroups = from course in Course.Catalog
                                group course by course.Category;

            foreach (var group in subjectGroups)
            {
                Console.WriteLine("Kategoria: " + group.Key);
                Console.WriteLine();

                foreach (var course in group)
                {
                    Console.WriteLine(course.Title);
                }
                Console.WriteLine();
            }
        }

        public static void ExpandingSimpleGroupingQuery()
        {
            var subjectGroups = Course.Catalog.GroupBy(course => course.Category);
        }

        public static void GroupingQueryItemProjection()
        {
            var subjectGroups = from course in Course.Catalog
                                group course.Title by course.Category;
        }

        public static void ExpandedGroupingQueryItemProjection()
        {
            var subjectGroups = Course.Catalog
                .GroupBy(course => course.Category, course => course.Title);
        }

        public static void GroupingQueryGroupProjection()
        {
            var subjectGroups =
               from course in Course.Catalog
               group course by course.Category into category
               select $"Liczba kursów w kategorii '{category.Key}': {category.Count()}.";
        }

        public static void ExpandedGroupingQueryGroupProjection()
        {
            IEnumerable<string> subjectGroups = Course.Catalog
                .GroupBy(course => course.Category)
                .Select(category =>
                   $"Liczba kursów w kategorii '{category.Key}': {category.Count()}.");
        }

        public static void GroupByWithKeyAndGroupProjection()
        {
            IEnumerable<string> subjectGroups = Course.Catalog.GroupBy(
                course => course.Category,
                (category, courses) =>
                   $"Liczba kursów w kategorii '{category}': {courses.Count()}.");
        }

        public static void GroupByWithKeyItemAndGroupProjection()
        {
            IEnumerable<string> subjectGroups = Course.Catalog.GroupBy(
                course => course.Category,
                course => course.Title,
                (category, titles) =>
                     $"Kategoria '{category}' zawiera {titles.Count()}: {2}" +
                         string.Join(", ", titles));
        }

        public static void CompositeGroupKey()
        {
            var bySubjectAndYear =
                from course in Course.Catalog
                group course by new { course.Category, course.PublicationDate.Year };
            foreach (var group in bySubjectAndYear)
            {
                Console.WriteLine($"{group.Key.Category} ({group.Key.Year})");
                foreach (var course in group)
                {
                    Console.WriteLine(course.Title);
                }
            }
        }
    }
}