﻿using System;
using System.IO;

namespace Disposable
{
    public static class UsingStatements
    {
        public static void UsingUsing()
        {
            using (StreamReader reader = File.OpenText(@"C:\temp\File.txt"))
            {
                Console.WriteLine(reader.ReadToEnd());
            }
        }

        public static void TheEffectOfUsing()
        {
            // Ta dodatkowa para nawiasów klamrowych została użyta celowo, pokazuje ona w jaki 
            // sposób instrukcja using tworzy własny zakres oraz jak zmienna utworzona w deklaracji
            // using jest dostępna wyłącznie w tym zakresie.
            {
                StreamReader reader = File.OpenText(@"C:\temp\File.txt");
                try
                {
                    Console.WriteLine(reader.ReadToEnd());
                }
                finally
                {
                    if (reader != null)
                    {
                        ((IDisposable)reader).Dispose();
                    }
                }
            }
        }

        public static void UsingDeclaration()
        {
            using StreamReader reader = File.OpenText(@"C:\temp\File.txt");
            Console.WriteLine(reader.ReadToEnd());
        }

        public static void StackedUsingStatements()
        {
            using (Stream source = File.OpenRead(@"C:\temp\File.txt"))
            using (Stream copy = File.Create(@"C:\temp\Copy.txt"))
            {
                source.CopyTo(copy);
            }
        }
    }
}
