﻿using System;

#nullable enable

namespace Nullability
{
    class Program
    {
        private readonly static LegacyComponent legacy = new LegacyComponent();

        static void Main()
        {
            string cannotBeNull = "Tekst";
            string? mayBeNull = null;

            Console.WriteLine(cannotBeNull.Length);

            if (mayBeNull != null)
            {
                // Dozwolone, gdyż ten wiersz kodu zostanie wykonany wyłącznie jeśli zmienna mayBeNull będzie różna od null
                Console.WriteLine(mayBeNull.Length);
            }

            // Dozwolone, gdyż kod sprawdza czy zmienna jest równa null i odpowiednio obsługuje tę sytuację
            Console.WriteLine(mayBeNull?.Length ?? 0);

            // W przypadku włączenia kontekstu ostrzeżenia nullable kompilator wyświetli ostrzeżenie w tym wierszu 
            Console.WriteLine(mayBeNull.Length);

            string? referenceFromLegacyComponent = legacy.GetReferenceWeKnowWontBeNull();
            string nonNullableReferenceFromLegacyComponent = referenceFromLegacyComponent!;

            Console.WriteLine(nonNullableReferenceFromLegacyComponent.Length);

            var nullableStrings = new string?[10];
            var nonNullableStrings = new string[10];
            Console.WriteLine(nullableStrings[0] == null);
            Console.WriteLine(nonNullableStrings[0] == null);
        }
    }
}
