# Rozdział 3. - Przykłady

Przykłady do rozdziału 3. pt. *Typy* książki *C# 8.0 Programowanie*.

## Klasy

* [Listing 1. Prosta klasa](Typy/Classes/Counter.cs#L3-L12)
* [Listing 2. Stosowanie niestandardowej klasy](Typy/Classes/Program.cs#L5-L19)

### Składowe statyczne

* [Listing 3. Klasa ze składowymi statycznymi](Typy/ClassWithStaticMembers/Counter.cs#L3-L16)
* [Listing 4. Użycie składowej statycznej](Typy/ClassWithStaticMembers/Program.cs#L19)
* [Listing 5. Słowo kluczowe this](Typy/ClassWithStaticMembers/CounterUsingThis.cs#L10)

### Klasy statyczne

* [Listing 6. Normalny sposób stosowania składowych statycznych](Typy/StaticUseNormal/Program.cs)
* [Listing 7. Stosowanie składowych statycznych bez jawnego określania klasy](Typy/StaticUseWithoutQualification/Program.cs)

### Typy referencyjne

* [Listing 8. Kopiowanie referencji](Typy/ReferenceTypes/Program.cs#L24-L32)
* [Listing 9. Porównywanie referencji](Typy/ReferenceTypes/Program.cs#L37-L51)
* [Listing 10. Porównywanie wartości](Typy/ReferenceTypes/Program.cs#L56-L71)
* [Listing 11. Określanie akceptowania wartości pustych](Typy/Nullability/Program.cs#L13-L14)
* [Listing 12. Włączanie kontekstu ostrzeżenia nullable w ustawieniach projektu](Typy/Nullability/Nullability.csproj#L9-L11)
* [Listing 13. Odwołania z użyciem referencji akceptującej wartości puste](Typy/Nullability/Program.cs#L18-L28)
* [Listing 14. Operator null forgiving](Typy/Nullability/Program.cs#L30-L31)
* [Listing 15. Obsługa wartości pustych i wzorzec Try — przed wprowadzeniem typów referencji akceptujących wartości puste](Typy/Nullability/NonNullableAwareTryPattern.cs#L10-L18)
* [Listing 16. Użycie wzorca Try ze świadomą obsługą wartości pustych](Typy/Nullability/NullableAwareTryPattern.cs#L10-L18)
* [Listing 17. Atrybut nullable](Typy/Nullability/NullableAwareTryPattern.cs#L20)
* [Listing 18. Tablice i akceptowanie wartości pustych](Typy/Nullability/Program.cs#L35-L36)

## Struktury

* [Listing 19. Prosta struktura](Typy/Structs/Point.cs#L3-L14)
* [Listing 20. Obsługa niestandardowego sposobu porównywania](Typy/Structs/Point.cs#L16-L34)
* [Listing 21. Porównywanie instancji struktur](Typy/Structs/Program.cs#L9-L22)
* [Listing 22. Struktura przeznaczona tylko do odczytu](Typy/ReadOnlyStructs/Point.cs#L5-L19)
* [Listing 23. Struktura tylko do odczytu we właściwości tylko do odczytu](Typy/ReadOnlyStructs/LocationRecord.cs#L3-L13)

## Składowe

### Pola
* [Listing 24. Stała](Typy/Fields/Program.cs#L7)

### Konstruktory

* [Listing 25. Błąd: nie podano identyfikatora URI](Typy/Constructors/Program.cs#L19)
* [Listing 26. Klasa z jednym konstruktorem](Typy/Constructors/Simple/Item.cs#L3-L12)
* [Listing 27. Użycie konstruktora](Typy/Constructors/Program.cs#L10)
* [Listing 28. Niepusty konstruktor bezargumentowy](Typy/Constructors/Simple/ItemWithId.cs#L3-L12)
* [Listing 29. Opcjonalna zmiana konstruktorów](Typy/Constructors/Chaining/ItemWithId.cs#L3-L24)
* [Listing 30. Przekazywanie argumentów w sekwencji wywoływanych konstruktorów](Typy/Constructors/MoreChaining/ItemWithId.cs#L9-L23)
* [Listing 31. Klasa z konstruktorem statycznym](Typy/Constructors/Static/Bar.cs#L5-L13)
* [Listing 32. Sytuacja, gdy kolejność inicjalizatorów ma znaczenie](Typy/Constructors/Static/StaticFieldOrder.cs#L5-L7)
* [Listing 33. Kolejność inicjalizacji](Typy/InitializationOrder/Program.cs#L5-L45)
* [Listing 34. Cykliczne odwołanie statyczne](Typy/InitializationOrderWithCircularDependencies/Program.cs#L5-L29)

### Dekonstruktory

* [Listing 35. Włączanie dekonstrukcji](Typy/Deconstruction/Size.cs#L3-L19)
* [Listing 36. Zastosowanie niestandardowej dekonstrukcji](Typy/Deconstruction/Program.cs#L15-L19)
* [Listing 37. Wzorzec pozycyjny z wykorzystaniem niestandardowe dekonstrukcji](Typy/Deconstruction/Program.cs#L21-L27)
* [Listing 38. Wzorzec pozycyjny z jawnym określeniem typu](Typy/Deconstruction/Program.cs#L29-L36)

### Metody

* [Listing 39. Zwracanie wielu wartości przy wykorzystaniu słowa kluczowego out](Typy/Methods/Program.cs#L40-L44)
* [Listing 40. Wywołanie metody z parametrem wyjściowym](Typy/Methods/Program.cs#L12)
* [Listing 41. Zastosowanie wyniku parametry wyjściowego w tym samym wyrażeniu](Typy/Methods/Program.cs#L17)
* [Listing 42. Zapis wyniku parametru wyjściowego w istniejącej zmiennej](Typy/Methods/Program.cs#L48-L52)
* [Listing 43. Pomijanie wyniku zwróconego przez parametr wyjściowy](Typy/Methods/Program.cs#L57)
* [Listing 44. Wywoływanie metody z argumentem ref](Typy/Methods/Program.cs#L64-L65)
* [Listing 45. Bardzo duży typ wartościowy](Typy/Methods/Rect.cs#L3-L17)
* [Listing 46. Metoda z parametrem wejściowym](Typy/Methods/Program.cs#L69)
* [Listing 47. Metoda z parametrem wejściowym](Typy/Methods/Program.cs#L73-L75)
* [Listing 48. Lokalna zmienna referencyjna](Typy/Methods/Program.cs#L25-L28)
* [Listing 49. Prawidłowe i nieprawidłowe przykłady zwracania referencji jako wyniku](Typy/Methods/Referable.cs#L5-L32)
* [Listing 50. Metoda z argumentami opcjonalnymi](Typy/Methods/Program.cs#L78-L83)
* [Listing 51. Pominięcie jednego argumentu](Typy/Methods/Program.cs#L30)
* [Listing 52. Określanie nazwy podawanego argumentu](Typy/Methods/Program.cs#L31)
* [Listing 53. Argumenty o niejasnym znaczeniu](Typy/Methods/Program.cs#L87)
* [Listing 54. Poprawa przejrzystości kodu poprzez podanie nazw argumentów](Typy/Methods/Program.cs#L93-L94)
* [Listing 55. Wybiórcze podawanie nazw argumentów](Typy/Methods/Program.cs#L99)
* [Listing 56. Przeciążanie metod](Typy/Methods/Overloads.cs#L7-L20)
* [Listing 57. Interpolacja łańcuchów znaków](Typy/Methods/Program.cs#L104-L108)
* [Listing 58. Formatowanie łańcuchów znaków](Typy/Methods/Program.cs#L113-L119)
* [Listing 59. Jawne przekazywanie wielu argumentów w formie tablicy](Typy/Methods/Program.cs#L120-L122)
* [Listing 60. Słowo kluczowe params](Typy/Methods/Program.cs#L127)
* [Listing 61. Funkcje lokalne](Typy/Methods/Program.cs#L130-L152)
* [Listing 62. Funkcje, których ciałem jest wyrażenie](Typy/Methods/Program.cs#L165-L166)
* [Listing 63. Metoda rozszerzenia](Typy/ExtensionMethods/StringExtensions.cs)
* [Listing 64. Metoda rozszerzenia dostępna dzięki użyciu odpowiedniej deklaracji przestrzeni nazw](Typy/ExtensionMethods/Program.cs)
* [Listing 65. Metoda rozszerzenia dostępna dzięki użyciu odpowiedniej dyrektywy using](Typy/ExtensionMethods/Other/Program.cs)

### Właściwości

* [Listing 66. Klasa definiująca prostą właściwość](Typy/Properties/Simple/HasProperty.cs#L3-L17)
* [Listing 67. Akcesory get i set zapisane w formie wyrażeń](Typy/Properties/ExpressionBodied/HasProperty.cs#L3-L11)
* [Listing 68. Właściwość automatyczna](Typy/Properties/Auto/HasProperty.cs#L3-L6)
* [Listing 69. Stosowanie właściwości](Typy/Properties/Program.cs#L10-L13)
* [Listing 70. Właściwość automatyczna z prywatnym akcesorem set](Typy/Properties/Auto/WithPrivateSetter.cs#L10)
* [Listing 71. Właściwość automatyczna bez akcesora set](Typy/Properties/Auto/NoSetter.cs#L10)
* [Listing 72. Inicjalizacja właściwości automatycznej bez akcesora set](Typy/Properties/Auto/WithAutos.cs#L3-L15)
* [Listing 73. Właściwość obliczana](Typy/Properties/Simple/Calculated.cs#L11-L17)
* [Listing 74. Właściwość tylko do odczytu, której ciałem jest wyrażenie](Typy/Properties/ExpressionBodied/Calculated.cs#L11)
* [Listing 75. Właściwość zmiennego typu wartościowego](Typy/Properties/Mutable/Item.cs#L3-L8)
* [Listing 76. Błąd: używając właściwości, nie można zmodyfikować właściwości typu wartościowego](Typy/Properties/Mutable/UseItem.cs#L12-L13)
* [Listing 77. Zastąpienie właściwości metodami](Typy/Properties/MethodsInstead/Item.cs#L3-L16)
* [Listing 78. Właściwość zwracająca referencję](Typy/Properties/ByRef/Item.cs#L3-L10)
* [Listing 79. Jawne utworzenie kopii](Typy/Properties/Mutable/UseItem.cs#L19-L21)
* [Listing 80. Jawne utworzenie referencji](Typy/Properties/ByRef/UseItem.cs#L9-L11)

### Indeksatory

* [Listing 81. Stosowanie indeksatora](Typy/Indexers/Program.cs#L10-L12)
* [Listing 82. Klasa z indeksatorem](Typy/Indexers/Indexed.cs#L3-L9)
* [Listing 83. Operator warunkowy wartości pustej zastosowany w indeksatorze](Typy/Indexers/Program.cs#L20)
* [Listing 84. Kod odpowiadający użyciu operatora warunkowego wartości pustej z indeksatorem](Typy/Indexers/Program.cs#L27)

### Składnia inicjalizatorów

* [Listing 85. Stosownie inicjalizatora obiektu](Typy/Initializers/Program.cs#L11-L16)
* [Listing 86. Stosowanie konstruktora i inicjalizatora obiektu](Typy/Initializers/Program.cs#L18-L22)
* [Listing 87. Użycie indeksatora w inicjalizatorze obiektu](Typy/Initializers/Program.cs#L24-L29)

### Operatory

* [Listing 88. Implementacja operatora +](Typy/Operators/Counter.cs#L17-L20)
* [Listing 89. Obsługa operandów innych typów](Typy/Operators/Counter.cs#L22-L30)
* [Listing 90. Operatory konwersji](Typy/Operators/Counter.cs#L32-L40)
* [Listing 91. Stosowanie jawnych operatorów konwersji](Typy/Operators/Program.cs#L9-L10)

### Typy zagnieżdżone

* [Listing 92. Prywatna klasa zagnieżdżona](Typy/NestedTypes/Program.cs#L7-L31)

## Interfejsy

* [Listing 93. Interfejs](Typy/Interfaces/IDoStuff.cs#L5-L12)
* [Listing 94. Implementacja interfejsu](Typy/Interfaces/DoStuff.cs#L7-L10)
* [Listing 95. Jawna implementacja interfejsu](Typy/Interfaces/DoStuff.cs#L12-L15)
* [Listing 96. Interfejs zawierający domyślną implementację metody](Typy/Interfaces/INamed.cs#L3-L7)
* [Listing 97. Interfejs zawierający stałą i typ wyliczeniowy](Typy/Interfaces/IContainMultitudes.cs#L3-L17)

## Typy wyliczeniowe

* [Listing 98. Typ wyliczeniowy definiujący wzajemnie wykluczające się opcje](Typy/Enums/PorridgeTemperature.cs#L3-L8)
* [Listing 99. Instrukcja switch korzystająca ze składowych typu wyliczeniowego](Typy/Enums/Program.cs#L12-L25)
* [Listing 100. Jawnie podane wartości typu wyliczeniowego](Typy/Enums/Ingredients.cs#L3-L14)
* [Listing 101. 64-bitowy typ wyliczeniowy](Typy/Enums/TooManyChoices.cs#L3-L7)
* [Listing 102. Mało pomocne zastosowanie wartości typu bool](Typy/Enums/Program.cs#L44)
* [Listing 103. Łatwość zrozumienia kodu dzięki użyciu typu wyliczeniowego](Typy/Enums/Program.cs#L46)

## Inne typy

* [Listing 104. Typ anonimowy](Typy/AnonymousTypes/Program.cs#L9-L11)