# Rozdział 1. - Przykłady

Przykłady do rozdziału 1. pt. *Prezentacja C#* książki *C# 8.0 Programowanie*.

## "Witaj, świecie!" oraz testy jednostkowe

Pierwsze cztery przykłady pochodzą z [rozwiązania](HelloWorld) będącego zwyczajnym przykładowym projektem typu "Witaj, świecie!", do którego dodano projekt testów jednostkowych.

* [Listing 1. Klasa testu jednostkowego dla pierwszego programu](HelloWorld/HelloWorld.Tests/WhenProgramRuns.cs)
* [Listing 2. Wywoływanie metody](HelloWorld/HelloWorld.Tests/WhenProgramRuns.cs#L17)
* [Listing 3. Zapewnienie dostępu do punktu wejścia do programu](HelloWorld/HelloWorld/Program.cs#L5)
* [Listing 4. Program.cs](HelloWorld/HelloWorld/Program.cs)

Z tego samego rozwiązania pochodzą listingi 6. i 9.

* [Listing 6. Deklaracja przestrzeni nazw](HelloWorld/HelloWorld/Program.cs#L3)
* [Listing 9. Klasa wraz z metodą](HelloWorld/HelloWorld/Program.cs#L5)

Na listingu 10. wprowadzamy do kodu poprawkę, dzięki której test będzie sprawdzony. Ta zmodyfikowana wersja kodu została umieszczona w odrębnym rozwiązaniu. (Jest ono identyczne z poprzednim, za wyjątkiem jednej zmiany opisanej w listingu 10.)

* [Listing 10. Wyświetlanie komunikatu](HelloWorldPassingTests/HelloWorld/Program.cs#L9)
* [Listing 11. Klasa testu z atrybutem](HelloWorldPassingTests/HelloWorld.Tests/WhenProgramRuns.cs#L6)
* Listing 12. Metody z adnotacjami [część 1.](HelloWorldPassingTests/HelloWorld.Tests/WhenProgramRuns.cs#L11) oraz [część 2.](HelloWorldPassingTests/HelloWorld.Tests/WhenProgramRuns.cs#L22)
* [Listing 13. Pole](HelloWorldPassingTests/HelloWorld.Tests/WhenProgramRuns.cs#L9)

## Przestrzenie nazw

Inne listingi zamieszczone w tym rozdziale przedstawiają przestrzenie nazw; można je znaleźć w osobnym [rozwiązaniu](Namespaces).  

* [Listing 5. Usuwanie niejednoznaczności poprzez użycie nazw zastępczych](Przestrzenie_nazw/MyApp/Ambiguity.cs)
* [Listing 7. Zagnieżdżanie deklaracji przestrzeni nazw](Przestrzenie_nazw/MyApp/Storage/NestedNamespaces.cs)
* [Listing 8. Zagnieżdżone przestrzenie nazw określone przy użyciu jednej deklaracji](Przestrzenie_nazw/MyApp/Storage/DottedNestedNamespaces.cs)

Listingi 6. oraz od 9. do 13. pochodzą z pierwszego listingu.
