﻿using System;

namespace DelegateConversion
{
    class Program
    {
        public static bool IsLongString(object o)
        {
            return o is string s && s.Length > 20;
        }

        static void Main(string[] args)
        {
            Predicate<object> po = IsLongString;
            Predicate<string> ps = po;
            Console.WriteLine(ps("Zbyt krótki."));
        }

        // Ten przykład przedstawia rozwiązanie, które nie działa. Zmień
        // #if false na #if true, aby zobaczyć błąd kompilacji
#if false
        public static void IllegalConversion()
        {
            Predicate<string> pred = IsLongString;
            Func<string, bool> f = pred;  // Spowoduje zgłoszenie błędu kompilacji
        }
#endif

        public static void DelegateToDelegate()
        {
            Predicate<string> pred = IsLongString;
            var pred2 = new Func<string, bool>(pred); // Mniej wydajne od bezpośredniej referencji


            Console.WriteLine(pred2("x"));
            Console.WriteLine(pred2(new string('x', 100)));
        }

        public static void DelegateToDelegateExplicit()
        {
            Predicate<string> pred = IsLongString;
            var pred2 = new Func<string, bool>(pred.Invoke);

            Console.WriteLine(pred2("x"));
            Console.WriteLine(pred2(new string('x', 100)));
        }

        public static void NewDelegateForcurrentTarget()
        {
            Predicate<string> pred = IsLongString;
            var pred2 = (Func<string, bool>)pred.Method.CreateDelegate(
              typeof(Func<string, bool>), pred.Target);

            Console.WriteLine(pred2("x"));
            Console.WriteLine(pred2(new string('x', 100)));
        }

        public static TResult DuplicateDelegateAs<TResult>(MulticastDelegate source)
            where TResult : Delegate
        {
            Delegate result = null;
            foreach (Delegate sourceItem in source.GetInvocationList())
            {
                var copy = sourceItem.Method.CreateDelegate(
                  typeof(TResult), sourceItem.Target);
                result = Delegate.Combine(result, copy);
            }

            return (TResult)(object)result;
        }
    }
}
