﻿using System;
using System.Collections.Generic;

namespace Generics
{
    public class Shape
    {
        public Rect BoundingBox { get; set; }
    }

    public class RoundedRectangle : Shape
    {
        public double CornerRadius { get; set; }
    }

    public class BoxAreaComparer : IComparer<Shape>
    {
        public int Compare(Shape x, Shape y)
        {
            double xArea = x.BoundingBox.Width * x.BoundingBox.Height;
            double yArea = y.BoundingBox.Width * y.BoundingBox.Height;

            return Math.Sign(xArea - yArea);
        }
    }

    public class CornerSharpnessComparer : IComparer<RoundedRectangle>
    {
        public int Compare(RoundedRectangle x, RoundedRectangle y)
        {
            // Wierzchołki o mniejszym promieniu są ostrzejsze, a zatem 
            // z punktu widzenia tego porównania mniejszy promień będzie "większy";
            // stąd też odwrócona kolejność argumentów w odejmowaniu. 
            return Math.Sign(y.CornerRadius - x.CornerRadius);
        }
    }
}
