﻿using System.Collections.Immutable;

namespace ImmutableCollections
{
    class Program
    {
        static void Main()
        {
            Create();
            CreateWithBuilder();
        }

        public static void Create()
        {
            IImmutableDictionary<int, string> d = ImmutableDictionary.Create<int, string>();
            d = d.Add(1, "jeden");
            d = d.Add(2, "dwa");
            d = d.Add(3, "trzy");

            System.Console.WriteLine(d[2]);
        }
    
        public static void CreateWithBuilder()
        {
            ImmutableDictionary<int, string>.Builder b =
                ImmutableDictionary.CreateBuilder<int, string>();
            b.Add(1, "jeden");
            b.Add(2, "dwa");
            b.Add(3, "trzy");
            IImmutableDictionary<int, string> d = b.ToImmutable();
        
            System.Console.WriteLine(d[2]);
        }
    }
}
