# Rozdział 8. - Przykłady

Przykłady do rozdziału 8. pt. *Wyjątki* książki *C# 8.0 Programowanie*.

## Źródła wyjątków

* [Listing 1. Wyjątek zgłaszany w wywołaniu składowej klasy należącej do biblioteki .NET](Wyjatki/Exceptions/Program.cs#L9-L18)
* [Listing 2. Potencjalny błąd wykrywany w trakcie działania programu](Wyjatki/Exceptions/Program.cs#L20-L23)

## Obsługa wyjątków

* [Listing 3. Obsługa wyjątków](Wyjatki/Exceptions/Program.cs#L27-L40)
* [Listing 4. Stosowanie wyjątku wewnątrz bloku catch](Wyjatki/Exceptions/Program.cs#L45-L59)
* [Listing 5. Obsługa wyjątków różnych typów](Wyjatki/Exceptions/Program.cs#L64-L81)
* [Listing 6. Blok catch z filtrem wyjątków](Wyjatki/Exceptions/Program.cs#L84-L96)
* [Listing 7. Zagnieżdżony kod obsługi wyjątków](Wyjatki/NestedExceptions/Program.cs#L8-L41)

## Zgłaszanie wyjątków

* [Listing 9. Zgłaszanie wyjątku](Wyjatki/Exceptions/Program.cs#L98-L105)
* [Listing 10. Jak nie należy powtórnie zgłaszać wyjątku](Wyjatki/Exceptions/Rethrow.cs#L9-L18)
* [Listing 11. Ponowne zgłaszanie wyjątku bez utraty kontekstu](Wyjatki/Exceptions/Rethrow.cs#L23-L31)

## Typy wyjątków

* [Listing 12. Klasa niestandardowego wyjątku](Wyjatki/Exceptions/Custom/NotSerializable/DeviceNotReadyException.cs#L5-L34)
* [Listing 13. Dodawanie możliwości serializacji](Wyjatki/Exceptions/Custom/Serializable/DeviceNotReadyException.cs#L28-L40)
* [Listing 14. Powiadomienie o nieobsługiwanym wyjątku](Wyjatki/Unhandled/Program.cs#L7-L19)
