﻿namespace Constraints
{
    // Ten przykład służy wyłącznie do celów demonstracyjnych.
    // W rzeczywistym programie lepiej skorzystać z typu Lazy<T>.
    public static class Deferred<T>
        where T : new()
    {
        private static T _instance;

        public static T Instance
        {
            get
            {
                if (_instance == null)
                {
                    _instance = new T();
                }
                return _instance;
            }
        }
    }
}