# Rozdział 2. - Przykłady

Przykłady do rozdziału 2. pt. *Postawy stosowania języka C#* książki *C# 8.0 Programowanie*.

* [Listing 1. Kod i nic tylko kod](../Rozdzial01/HelloWorldPassingTests/HelloWorld/Program.cs#L9)
* [Listing 2. Cały kod](../Rozdzial01/HelloWorldPassingTests/HelloWorld/Program.cs)

Zmienne

* [Listing 3. Deklaracje zmiennych](PodstawyStosowania/BasicCoding/Variables.cs#L9-L12)
* [Listing 4. Przypisywanie wartości do zadeklarowanych wcześniej zmiennych](PodstawyStosowania/BasicCoding/Variables.cs#L14-L15)
* [Listing 5. Błąd: niewłaściwy typ](PodstawyStosowania/BasicCoding/Variables.cs#L21)
* [Listing 6. Niejawne typy zmiennych i słowo kluczowe var](PodstawyStosowania/BasicCoding/Variables.cs#L32-L34)
* [Listing 7. Błąd: niewłaściwy typ (ponownie)](PodstawyStosowania/BasicCoding/Variables.cs#L46-L47)
* [Listing 8. Wiele zmiennych tworzonych w jednej deklaracji](PodstawyStosowania/BasicCoding/Variables.cs#L24)
* [Listing 9. Stosowanie zmiennych](PodstawyStosowania/BasicCoding/Variables.cs#L122-L133)
* [Listing 10. Błąd: użycie niezainicjowanej zmiennej](PodstawyStosowania/BasicCoding/Variables.cs#L49-L50)
* [Listing 11. Błąd: poza zakresem](PodstawyStosowania/BasicCoding/Variables.cs#L53-L61)
* [Listing 12. Zmienna zadeklarowana poza blokiem i używana wewnątrz niego](PodstawyStosowania/BasicCoding/Variables.cs#L138-L142)
* [Listing 13. Błąd: próba użycia zmiennej poza jej zakresem](PodstawyStosowania/BasicCoding/Variables.cs#L65-L70)
* [Listing 14. Błąd: zaskakujący konflikt nazw](PodstawyStosowania/BasicCoding/Variables.cs#L75-L82)
* [Listing 15. Błąd: ukrywanie zmiennej](PodstawyStosowania/BasicCoding/Variables.cs#L92-L110)


Instrukcje i wyrażenia

* [Listing 16. Kilka instrukcji](PodstawyStosowania/BasicCoding/StatementsAndExpressions.cs#L11-L15)
* [Listing 17. Blok](PodstawyStosowania/BasicCoding/StatementsAndExpressions.cs#L20-L26)
* [Listing 18. Wyrażenia wewnątrz innych wyrażeń](PodstawyStosowania/BasicCoding/StatementsAndExpressions.cs#L31-L33)
* [Listing 19. Wyrażenia wywołania metod jako instrukcje](PodstawyStosowania/BasicCoding/StatementsAndExpressions.cs#L38-L41)
* [Listing 20. Błędy: przykłady wyrażeń, które nie mogą być instrukcjami](PodstawyStosowania/BasicCoding/StatementsAndExpressions.cs#L50-L51)
* [Listing 21. Przypisania jako wyrażenia](PodstawyStosowania/BasicCoding/StatementsAndExpressions.cs#L57-L64)
* [Listing 22. Kolejność przetwarzania operandów](PodstawyStosowania/OperandEvaluationOrder/Program.cs#L5-L18)
* [Listing 23. Kolejność przetwarzania operandów w przypadku wyrażeń zagnieżdżonych](PodstawyStosowania/OperandEvaluationOrderNested/Program.cs#L15-L18)

Komentarze i białe znaki 
 
 * [Listing 24. Komentarze jednowierszowe](PodstawyStosowania/BasicCoding/CommentsAndWhitespace.cs#L9-L10)
 * [Listing 25. Komentarze oddzielone](PodstawyStosowania/BasicCoding/CommentsAndWhitespace.cs#L15-L21)
 * [Listing 26. Komentarze wielowierszowe](PodstawyStosowania/BasicCoding/CommentsAndWhitespace.cs#L23-L27)
 * [Listing 27. Białe znaki bez znaczenia](PodstawyStosowania/BasicCoding/CommentsAndWhitespace.cs#L32-L36)

Dyrektywy preprocesora

* [Listing 28. Kompilacja warunkowa](PodstawyStosowania/BasicCoding/PreprocessingDirectives.cs#L9-L15)
* [Listing 29. Metoda warunkowa](PodstawyStosowania/BasicCoding/PreprocessingDirectives.cs#L18-L22)
* [Listing 30. Generowanie błędu kompilatora](PodstawyStosowania/BasicCoding/PreprocessingDirectives.cs#L26-L28)
* [Listing 31. Dyrektywa #line i celowy błąd](PodstawyStosowania/BasicCoding/PreprocessingDirectives.cs#L36-L37)
* [Listing 32. Wyłączanie ostrzeżeń kompilatora](PodstawyStosowania/BasicCoding/PreprocessingDirectives.cs#L40-L41)

Podstawowe typy danych 

* [Listing 33. Niejawne konwersje liczb](PodstawyStosowania/BasicCoding/Conversions.cs#L10-L14)
* [Listing 34. Błąd: niedostępna konwersja niejawna](PodstawyStosowania/BasicCoding/Conversions.cs#L23-L25)
* [Listing 35. Jawna konwersja przy użyciu rzutowania](PodstawyStosowania/BasicCoding/Conversions.cs#L31-L33)
* [Listing 36. Wykorzystanie niesprawdzanego przepełnienia danych typu całkowitego](PodstawyStosowania/BasicCoding/Conversions.cs#L40-L45)
* [Listing 37. Wyrażenie sprawdzane](PodstawyStosowania/BasicCoding/Conversions.cs#L55)
* [Listing 38. Instrukcja sprawdzana](PodstawyStosowania/BasicCoding/Conversions.cs#L57-L61)
* [Listing 39. Zastosowanie typu BigInteger](PodstawyStosowania/UsingBigInteger/Program.cs)
* [Listing 40. Znaki a dane typu char](PodstawyStosowania/BasicCoding/StringsAndChars.cs#L12-L13)
* [Listing 41. Wyrażenia w łańcuchach znaków](PodstawyStosowania/BasicCoding/StringsAndChars.cs#L20)
* [Listing 42. Umieszczanie w łańcuchach bardziej złożonych wyrażeń](PodstawyStosowania/BasicCoding/StringsAndChars.cs#L22-L23)
* [Listing 43. Wynik interpolacji łańcucha znaków](PodstawyStosowania/BasicCoding/StringsAndChars.cs#L33-L36)
* [Listing 44. Specyfikatory formatu](PodstawyStosowania/BasicCoding/StringsAndChars.cs#L44)
* [Listing 45. Specyfikatory formatu użyte z niezmiennikiem kulturowym](PodstawyStosowania/BasicCoding/StringsAndChars.cs#L51)
* [Listing 46. Tworzenie i stosowanie krotek](PodstawyStosowania/BasicCoding/Tuples.cs#L9-L10)
* [Listing 47. Określanie nazw elementów krotek w inicjalizatorze](PodstawyStosowania/BasicCoding/Tuples.cs#L15-L16)
* [Listing 48. Wnioskowanie nazw elementów krotki na podstawie użytych zmiennych](PodstawyStosowania/BasicCoding/Tuples.cs#L21-L23)
* [Listing 49. Domyślne nazwy elementów krotek](PodstawyStosowania/BasicCoding/Tuples.cs#L28-L29)
* [Listing 50. Strukturalna równoważność krotek](PodstawyStosowania/BasicCoding/Tuples.cs#L34-L36)
* [Listing 51. Tworzenie i dekonstrukcja krotek](PodstawyStosowania/BasicCoding/Tuples.cs#L44-L50)

Operatory

* [Listing 52. Warunkowy operator AND](PodstawyStosowania/BasicCoding/Operators.cs#L9)
* [Listing 53. Operator trójargumentowy](PodstawyStosowania/BasicCoding/Operators.cs#L17)
* [Listing 54. Zastosowanie przetwarzania warunkowego](PodstawyStosowania/BasicCoding/Operators.cs#L24)
* [Listing 55. Operator null coalescing](PodstawyStosowania/BasicCoding/Operators.cs#L31)
* [Listing 56. Użycie operatora warunkowego wartości pustych oraz operatora null coalescing](PodstawyStosowania/BasicCoding/Operators.cs#L38)
* [Listing 57. Wyrażenie warunkowe jako argument wywołania metody](PodstawyStosowania/BasicCoding/Operators.cs#L48)
* [Listing 58. Życie bez operatora warunkowego](PodstawyStosowania/BasicCoding/Operators.cs#L56-L65)
* [Listing 59. Przypisanie i dodawanie](PodstawyStosowania/BasicCoding/Operators.cs#L75)
* [Listing 60. Złożone przypisanie (dodawanie)](PodstawyStosowania/BasicCoding/Operators.cs#L79)

Sterowanie przepływem

* [Listing 61. Prosta instrukcja if](PodstawyStosowania/BasicCoding/FlowControl.cs#L11-L14)
* [Listing 62. Zapewne nie o to nam chodziło](PodstawyStosowania/BasicCoding/FlowControl.cs#L23-L25)
* [Listing 63. If oraz else](PodstawyStosowania/BasicCoding/FlowControl.cs#L30-L37)
* [Listing 64. Wybór jednej spośród kilku możliwości](PodstawyStosowania/BasicCoding/FlowControl.cs#L42-L53)
* [Listing 65. Zbyt wiele bloków](PodstawyStosowania/BasicCoding/FlowControl.cs#L58-L72)
* [Listing 66. Instrukcja switch operująca na łańcuchach znaków](PodstawyStosowania/BasicCoding/FlowControl.cs#L77-L101)
* [Listing 67. Przechodzenie stosowane w kodzie C, niedozwolone w C#](PodstawyStosowania/BasicCoding/FlowControl.cs#L110-L117)
* [Listing 68. Przechodzenie do kolejnej sekcji case w C#](PodstawyStosowania/BasicCoding/FlowControl.cs#L123-L131)
* [Listing 69. Pętla while](PodstawyStosowania/BasicCoding/FlowControl.cs#L136-L139)
* [Listing 70. Pętla do](PodstawyStosowania/BasicCoding/FlowControl.cs#L144-L150)
* [Listing 71. Modyfikacja elementów tablicy przy użyciu pętli for](PodstawyStosowania/BasicCoding/FlowControl.cs#L155-L158)
* [Listing 72. Kilka inicjalizatorów oraz iteratorów](PodstawyStosowania/BasicCoding/FlowControl.cs#L160)
* [Listing 73. Zagnieżdżone pętle for](PodstawyStosowania/BasicCoding/FlowControl.cs#L171-L176)
* [Listing 74. Przeglądanie kolekcji przy użyciu pętli foreach](PodstawyStosowania/BasicCoding/FlowControl.cs#L182-L186)
* [Listing 75. Ogólny sposób przetwarzania kolekcji](PodstawyStosowania/BasicCoding/FlowControl.cs#L191-L197)

Wzorce

* [Listing 76. Wzorce krotki](PodstawyStosowania/BasicCoding/Patterns.cs#L9-L23)
* [Listing 77. Wzorce typu](PodstawyStosowania/BasicCoding/Patterns.cs#L28-L37)
* [Listing 78. Wzorzec pozycyjny](PodstawyStosowania/BasicCoding/Patterns.cs#L48-L50)
* [Listing 79. Wzorzec pozycyjny składający się ze wzorca stałej i wzorca typu](PodstawyStosowania/BasicCoding/Patterns.cs#L44-L46)
* [Listing 80. Wzorzec pozycyjny ze słowem kluczowym var](PodstawyStosowania/BasicCoding/Patterns.cs#L56-L58)
* [Listing 81. Wzorzec pozycyjny ze wzorcem pominięcia](PodstawyStosowania/BasicCoding/Patterns.cs#L52-L54)
* [Listing 82. Wzorzec właściwości](PodstawyStosowania/BasicCoding/Patterns.cs#L66-L68)
* [Listing 83. Wzorzec właściwości zwracający wynik](PodstawyStosowania/BasicCoding/Patterns.cs#L73-L75)
* [Listing 84. Wzorzec właściwości z zagnieżdżonym wzorcem zwracającym wynik](PodstawyStosowania/BasicCoding/Patterns.cs#L78-L82)
* [Listing 85. Wzorzec z klauzulą when](PodstawyStosowania/BasicCoding/Patterns.cs#L90-L92)
* [Listing 86. Wzorce, lecz nie w wyrażeniach](PodstawyStosowania/BasicCoding/Patterns.cs#L98-L104)
* [Listing 87. Wyrażenie switch](PodstawyStosowania/BasicCoding/Patterns.cs#L109-L115)
* [Listing 88. Wyrażenie is](PodstawyStosowania/BasicCoding/Patterns.cs#L121)
* [Listing 89. Użycie wartości pobranych ze wzorca wyrażenia is](PodstawyStosowania/BasicCoding/Patterns.cs#L126-L129)
* [Listing 90. We wzorcach w wyrażeniu is nie trzeba stosować klauzuli when](PodstawyStosowania/BasicCoding/Patterns.cs#L131-L134)
