# Rozdział 17. - Przykłady

Przykłady do rozdziału 17. pt. *Asynchroniczne cechy języka* książki *C# 8.0 Programowanie*.

## Słowa kluczowe: async oraz await

* [Listing 1. Stosowanie słów kluczowych async i await podczas pobierania nagłówków HTTP](Asynchronicznosc/AsyncAwait/MainWindow.xaml.cs#L39-L50)
* [Listing 2. Wywoływanie metody asynchronicznej](Asynchronicznosc/AsyncAwait/MainWindow.xaml.cs#L33-L37)
* [Listing 3. Samodzielne tworzenie odpowiednika metody asynchronicznej](Asynchronicznosc/AsyncAwait/MainWindow.xaml.cs#L52-L72)
* [Listing 4. Stosowanie metody ConfigureAwait](Asynchronicznosc/AsyncAwait/ConfigureAwaitWindow.xaml.cs#L25-L36)
* [Listing 5. Wykonywanie wielu operacji asynchronicznych](Asynchronicznosc/AsyncAwait/LoopWindow.xaml.cs#L37-L53)
* [Listing 6. Niekompletna samodzielna implementacja pętli asynchronicznej](Asynchronicznosc/AsyncAwait/LoopWindow.xaml.cs#L55-L87)
* [Listing 7. Metoda IEnumerator.MoveNext, która nie wspiera operacji asynchronicznych](Asynchronicznosc/AsyncSequences/Program.cs#L36)
* [Listing 8. IAsyncEnumerable&lt;T&gt; oraz IAsyncEnumerator&lt;T&gt;](Asynchronicznosc/AsyncSequences/Program.cs#L39-L50)
* [Listing 9. Tworzenie i stosowania asynchronicznego typu wyliczalnego](Asynchronicznosc/AsyncSequences/Program.cs#L1-L30)
* [Listing 10. Stosowanie i implementacja interfejsu IAsyncDisposable](Asynchronicznosc/AsyncDispose/Program.cs)
* [Listing 11. Zwracanie zadania](Asynchronicznosc/AsyncAwait/LoopWindow.xaml.cs#L35)
* [Listing 12. Zwracanie zadania Task&lt;T&gt;](Asynchronicznosc/AsyncAwait/LoopWindow.xaml.cs#L89-L106)
* [Listing 13. Asynchroniczne wyrażenie lambda](Asynchronicznosc/AsyncAwait/MainWindow.xaml.cs#L24-L30)

## Wzorzec słowa kluczowego await

* [Listing 14. Wywoływanie niestandardowej implementacji typu współpracującego z await](Asynchronicznosc/AwaitPattern/Program.cs#L13-L22)
* [Listing 15. Wyjątkowo prosta implementacja wzorca słowa kluczowego await](Asynchronicznosc/AwaitPattern/MyAwaitableType.cs#L6-L24)
* [Listing 16. Bardzo ogólne przybliżenie działania słowa kluczowego await](Asynchronicznosc/AwaitPattern/Program.cs#L27-L44)
* [Listing 17. Nieco lepsze przybliżenie sposobu działania słowa kluczowego await](Asynchronicznosc/AwaitPattern/Program.cs#L47-L73)

## Obsługa błędów

* [Listing 18. Kilka potencjalnych źródeł niepowodzenia](Asynchronicznosc/ErrorHandling/Program.cs#L25-L45)
* [Listing 19. Obsługa wyjątków zgłaszanych w wyrażeniu await](Asynchronicznosc/ErrorHandling/Program.cs#L49-L58)
* [Listing 20. W jaki sposób nie należy sprawdzać poprawności argumentów](Asynchronicznosc/ErrorHandling/Program.cs#L63-L68)
* [Listing 21. Weryfikacja argumentów metody asynchronicznej](Asynchronicznosc/ErrorHandling/Program.cs#L77-L89)
* [Listing 22. Zastosowanie słowa kluczowego await i metody Wait](Asynchronicznosc/ErrorHandling/Program.cs#L92-L106)
* [Listing 23. Poszukiwanie dodatkowych wyjątków](Asynchronicznosc/ErrorHandling/Program.cs#L110-L128)
* [Listing 24. W jaki sposób nie należy wykonywać wielu współbieżnych operacji](Asynchronicznosc/ErrorHandling/Program.cs#L131-L144)
