# Rozdział 11. - Przykłady

Przykłady do rozdziału 11. pt. *Reactive Extensions* książki *C# 8.0 Programowanie*.

## Fundamental Interfaces

* [Listing 1. Interfejsy IObservable&lt;T&gt; oraz IObserver&lt;T&gt;](Rx/FundamentalInterfaces/Program.cs#L8-L18)
* [Listing 2. Prosta implementacja interfejsu IObserver&lt;T&gt;](Rx/FundamentalInterfaces/MySubscriber.cs#L5-L10)
* [Listing 3. Proste zimne źródło zdarzeń](Rx/FundamentalInterfaces/SimpleColdSource.cs#L5-L20)
* [Listing 4. Dołączanie obserwatora do źródła](Rx/FundamentalInterfaces/Program.cs#L25-L27)
* [Listing 5. Zimne źródło udostępniające zawartość pliku](Rx/FundamentalInterfaces/FilePusher.cs#L6-L32)
* [Listing 6. Obsługa błędów systemu plików, lecz nie błędów obserwatora](Rx/FundamentalInterfaces/FilePusherWithErrorHandling.cs#L14-L58)
* [Listing 7. Źródło IObservable&lt;T&gt; monitorujące naciśnięcia klawiszy](Rx/FundamentalInterfaces/KeyWatcher.cs#L6-L57)
* [Listing 8. Dołączanie obserwatora do źródła](Rx/FundamentalInterfaces/Program.cs#L32-L35)

## Publikowanie i subskrypcja z wykorzystaniem delegatów

* [Listing 9. Źródło obserwowalne wykorzystujące delegaty](Rx/DelegateBasedPubSub/DelegateBasedSource.cs#L9-L23)
* [Listing 10. Źródło asynchroniczne](Rx/DelegateBasedPubSub/AsyncSource.cs#L9-L23)
* [Listing 11. Źródło ciepłe wykorzystujące delegaty](Rx/DelegateBasedPubSub/Program.cs#L16-L28)
* [Listing 12. Subskrypcja bez implementowania interfejsu IObserver&lt;T&gt;](Rx/DelegateBasedPubSub/Program.cs#L33-L35)

## Generator sekwencji

* [Listing 13. Generowanie elementów](Rx/Generation/Program.cs#L15-L23)
* [Listing 14. Generowanie elementów z opóźnieniami](Rx/Generation/Program.cs#L28-L37)

## Zapytania LINQ

* [Listing 15. Filtrowanie elementów przy użyciu zapytania LINQ](Rx/LinqQueries/MainWindow.xaml.cs#L19-L28)
* [Listing 16. Przechwytywanie myszy](Rx/LinqQueries/MainWindow.xaml.cs#L31-L42)

### Operatory grupowania

* [Listing 17. Grupowanie zdarzeń](Rx/LinqQueries/Grouping.cs#L12-L30)

### Operatory Join

* [Listing 18. Wyrażenie zapytania z klauzulą join](Rx/LinqQueries/QueryExpressionJoin.xaml.cs#L18-L32)
* [Listing 19. Metoda Join](Rx/LinqQueries/CodeJoin.xaml.cs#L28-L32)
* [Listing 20. Dodawanie nowej linii dla każdej operacji przeciągnięcia wskaźnika myszy](Rx/LinqQueries/GroupJoin.xaml.cs#L30-L44)

## Operatory biblioteki Rx

### Merge

* [Listing 21. Łączenie obserwowalnych źródeł](Rx/RxQueryOperators/MergingObservables.xaml.cs#L19-L39)

### Operatory Buffer i Window

* [Listing 22. Wygładzanie wyników przy użyciu operatora Buffer](Rx/RxQueryOperators/SmoothingWithBuffer.xaml.cs#L43-L46)
* [Listing 23. Wygładzanie z użyciem operatora Window](Rx/RxQueryOperators/SmoothingWithWindow.xaml.cs#L41-L48)
* [Listing 24. Podział tekstu na słowa przy użyciu okien](Rx/RxQueryOperators/WordBreaking.cs#L14-L21)
* [Listing 25. Dzielenie słów z wykorzystaniem operatora Buffer](Rx/RxQueryOperators/WordBreaking.cs#L28-L32)

### Operator Scan 

* [Listing 26. Prosty rynek notowań ze strumieniem testowym](Rx/RxQueryOperators/Trade.cs#L6-L32)
* [Listing 27. Sumowanie z wykorzystaniem operatora Aggregate](Rx/RxQueryOperators/Aggregation.cs#L10-L14)
* [Listing 28. Suma częściowa wyliczana przy użyciu operatora Scan](Rx/RxQueryOperators/Aggregation.cs#L19-L23)

## Mechanizmy szeregujące

* [Listing 29. Metoda ObserveOn](Rx/RxSchedulers/MainWindow.xaml.cs#L17-L24)
* [Listing 30. Przeciążona wersja metody ObserveOn przeznaczona dla aplikacji WPF](Rx/RxSchedulers/WpfSpecificObserveOn.xaml.cs#L16-L22)
* [Listing 31. Obserwowanie bieżącego obiektu Dispatcher](Rx/RxSchedulers/UseCurrentDispatcher.xaml.cs#L16-L22)

## Tematy

* [Listing 32. Implementacja interfejsu IObservable&lt;T&gt; przy użyciu obiektu Subject&lt;T&gt;](Rx/RxSubjects/KeyWatcher.cs#L6-L22)
* [Listing 33. Udostępnianie implementacji IObservable&lt;T&gt; jako właściwości](Rx/RxSubjects/ObservableProperty/KeyWatcher.cs#L6-L19)

## Dostosowanie

* [Listing 34. Konwersja IEnumerable&lt;T&gt; na IObservable&lt;T&gt;](Rx/Adaptation/IEnumerableToObservable.cs#L9-L13)
* [Listing 35. Jak mogłoby wyglądać użycie metody ToObservable, gdyby nie musiała ona korzystać z mechanizmu szeregującego](Rx/Adaptation/IEnumerableToObservable.cs#L15-L41)
* [Listing 36. Stosowanie źródła IObservable&lt;T&gt; jako obiektu IEnumerable&lt;T&gt;](Rx/Adaptation/IObservableToEnumerable.cs#L8-L14)
* [Listing 37. Opakowywanie zdarzeń w formie obiektu IObservable&lt;T&gt;](Rx/Adaptation/Events.cs#L12-L19)
* [Listing 38. Opakowywanie zdarzeń z wykorzystaniem delegatów](Rx/Adaptation/Events.cs#L28-L30)
* [Listing 39. Udostępnianie danej Task&lt;T&gt; jako IObservable&lt;T&gt;](Rx/Adaptation/Async.cs#L13-L19)
* [Listing 40. Tworzenie nowego zadania dla każdego subskrybenta](Rx/Adaptation/Async.cs#L24-L32)

## Operacje z uzależnieniami czasowymi

* [Listing 41. Regularne zwracanie elementów przy użyciu metody Interval](Rx/Timed/Intervals.cs#L11-L12)
* [Listing 42. Dwóch subskrybentów źródła utworzonego przy użyciu metody Interval](Rx/Timed/Intervals.cs#L20-L22)
* [Listing 43. Zliczanie słów wpisywanych w ciągu minuty](Rx/Timed/WordsPerMinute.cs#L20-L27)
* [Listing 44. Użycie metody Timer, która zwraca jeden element](Rx/Timed/Timers.cs#L11-L12)
* [Listing 45. Elementy ze znacznikami czasu](Rx/Timed/Timers.cs#L17-L20)
* [Listing 46. Mierzenie odstępów pomiędzy elementami](Rx/Timed/Timers.cs#L25-L28)
* [Listing 47. Okna czasowe tworzone przy użyciu operatora Buffer](Rx/Timed/WordsPerMinute.cs#L34-L37)
* [Listing 48. Zachodzące na siebie okna pomiarowe](Rx/Timed/WordsPerMinute.cs#L44-L47)
