# Rozdział 7. - Przykłady

Przykłady do rozdziału 7. pt. *Cykl życia obiektów* książki *C# 8.0 Programowanie*.

## Mechanizm odzyskiwania pamięci

* [Listing 1. Używanie i usuwanie obiektów](CyklZyciaObiektow/GarbageCollection/Program.cs#L26-L32)
* [Listing 2. Okropnie nieefektywny fragment kodu](CyklZyciaObiektow/GarbageCollection/Program.cs#L9-L20)
* [Listing 3. Stosowanie słabych referencji do obsługi pamięci podręcznej](CyklZyciaObiektow/WeakRefs/WeakCache.cs#L6-L34)
* [Listing 4. Sprawdzanie działania klasy korzystającej ze słabych referencji](CyklZyciaObiektow/WeakRefs/Program.cs#L6-L52)
* [Listing 5. Nieduży obiekt z wielką tablicą](CyklZyciaObiektow/GarbageCollection/GreedyObject.cs#L3-L6)
* [Listing 6. Włączanie trybu serwerowego w pliku projektu aplikacji .NET Core](CyklZyciaObiektow/NetCoreServerGc/NetCoreServerGc.csproj#L8-L10)
* [Listing 7. Konfiguracja serwerowego trybu odzyskiwania pamięci (dla .NET Framework)](CyklZyciaObiektow/NetFxServerGc/App.config)

## Destruktory i finalizacja

* [Listing 8. Klasa definiująca destruktor](CyklZyciaObiektow/GarbageCollection/LetMeKnowMineEnd.cs#L5-L11)

# Interfejs IDisposable

* [Listing 9. Interfejs IDisposable](CyklZyciaObiektow/Disposable/Program.cs#L13-L16)
* [Listing 10. Instrukcja using](CyklZyciaObiektow/Disposable/UsingStatements.cs#L8-L14)
* [Listing 11. Pełny odpowiednik wykorzystania instrukcji using](CyklZyciaObiektow/Disposable/UsingStatements.cs#L21-L34)
* [Listing 12. Deklaracja using](CyklZyciaObiektow/Disposable/UsingStatements.cs#L39-L40)
* [Listing 13. Sekwencja instrukcji using](CyklZyciaObiektow/Disposable/UsingStatements.cs#L45-L49)
* [Listing 14. Pętla foreach](CyklZyciaObiektow/Disposable/ForeachDisposal.cs#L11-L14)
* [Listing 15. Pełne rozwinięcie pętli foreach](CyklZyciaObiektow/Disposable/ForeachDisposal.cs#L18-L36)
* [Listing 16. Zwalnianie obiektu przechowywanego w polu innego obiektu](CyklZyciaObiektow/Disposable/Logger.cs#L6-L25)
* [Listing 17. Niestandardowa logika finalizacji i zwalniania](CyklZyciaObiektow/Disposable/MyFunkyStream.cs#L6-L33)

## Pakowanie

* [Listing 18. Użycie danej typu int jako obiektu](CyklZyciaObiektow/Boxing/Program.cs#L5-L17)
* [Listing 19. W rzeczywistości nie tak działa pakowanie](CyklZyciaObiektow/Boxing/Box.cs#L3-L16)
* [Listing 20. Rozpakowywanie wartości z użyciem wzorca typu](CyklZyciaObiektow/Boxing/Unboxing.cs#L9-L12)
* [Listing 21. Ilustracja pułapek zmiennych struktur](CyklZyciaObiektow/MutableStructPitfalls/Program.cs#L5-L54)
* [Listing 22. Rozpakowanie wartości int do zmiennej typu int oraz typu dopuszczającego wartość pustą](CyklZyciaObiektow/Boxing/Unboxing.cs#L17-L20)
