﻿using System;
using System.IO;

namespace Disposable
{
    public class MyFunkyStream : Stream
    {
        // Tak klasa służy wyłącznie do celów demonstracyjnych. 
        // Zazwyczaj lepszym rozwiązaniem będzie użycie jednego 
        // z typów pochodnych klasy SafeHandle.
        private IntPtr _myCustomLibraryHandle;
        private Logger _log;

        protected override void Dispose(bool disposing)
        {
            base.Dispose(disposing);

            if (_myCustomLibraryHandle != IntPtr.Zero)
            {
                MyCustomLibraryInteropWrapper.Close(_myCustomLibraryHandle);
                _myCustomLibraryHandle = IntPtr.Zero;
            }
            if (disposing)
            {
                if (_log != null)
                {
                    _log.Dispose();
                    _log = null;
                }
            }
        }

        // ... tu można umieścić implementacje abstrakcyjnych metod klasy  Stream

        public override bool CanRead => throw new NotImplementedException();
        public override bool CanSeek => throw new NotImplementedException();
        public override bool CanWrite => throw new NotImplementedException();
        public override long Length => throw new NotImplementedException();
        public override long Position
        {
            get => throw new NotImplementedException();
            set => throw new NotImplementedException();
        }
        public override void Flush() => throw new NotImplementedException();
        public override int Read(byte[] buffer, int offset, int count) => throw new NotImplementedException();
        public override long Seek(long offset, SeekOrigin origin) => throw new NotImplementedException();
        public override void SetLength(long value) => throw new NotImplementedException();
        public override void Write(byte[] buffer, int offset, int count) => throw new NotImplementedException();
    }
}
