namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter16.Listing16_20
{
    using System;
    using Listing16_10;
    using System.Collections.Generic;

    public class Program
    {
        public static void Main()
        {
            var game = new Pair<string>("Redskins", "Eagles");
            foreach(string name in game.GetReverseEnumerator())
            {
                Console.WriteLine(name);
            }
        }
    }

    public struct Pair<T> : IPair<T>, IEnumerable<T>
    {
        #region Skadowe
        public Pair(T first, T second)
        {
            First = first;
            Second = second;
        }
        public T First { get; }
        public T Second { get; }

        public T this[PairItem index]
        {
            get
            {
                switch(index)
                {
                    case PairItem.First:
                        return First;
                    case PairItem.Second:
                        return Second;
                    default:
                        throw new NotImplementedException(
                            string.Format(
                            "Wyliczenie nie zawiera wartoci {0}",
                            index.ToString()));
                }
            }
        }
        #endregion Skadowe

        // Uywanie instrukcji yield return w metodzie zwracajcej obiekt typu IEnumerable<T>
        public IEnumerable<T> GetReverseEnumerator()
        {
            yield return Second;
            yield return First;
        }

        // Koczenie iterowania za pomoc instrukcji yield break
        public System.Collections.Generic.IEnumerable<T> GetNotNullEnumerator()
        {
            if((First == null) || (Second == null))
            {
                yield break;
            }
            yield return Second;
            yield return First;
        }


        #region IEnumerable<T>
        public IEnumerator<T> GetEnumerator()
        {
            yield return First;
            yield return Second;
        }
        #endregion IEnumerable<T>

        #region Skadowe z interfejsu IEnumerable
        System.Collections.IEnumerator
            System.Collections.IEnumerable.GetEnumerator()
        {
            return GetEnumerator();
        }
        #endregion
    }
}
