namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter15.Listing15_05
{
    using System;
    using System.Collections.Generic;
    using System.Linq;

    public class Program
    {
        private static string[] Keywords = {
            "abstract", "add*", "alias*", "as", "ascending*",
            "async*", "await*", "base","bool", "break",
            "by*", "byte", "case", "catch", "char", "checked",
            "class", "const", "continue", "decimal", "default",
            "delegate", "descending*", "do", "double",
            "dynamic*", "else", "enum", "event", "equals*",
            "explicit", "extern", "false", "finally", "fixed",
            "from*", "float", "for", "foreach", "get*", "global*",
            "group*", "goto", "if", "implicit", "in", "int",
            "into*", "interface", "internal", "is", "lock", "long",
            "join*", "let*", "nameof*", "namespace", "new", "null",
            "on*", "operator", "orderby*", "out", "override",
            "object", "params", "partial*", "private", "protected",
            "public", "readonly", "ref", "remove*", "return", "sbyte",
            "sealed", "select*", "set*", "short", "sizeof",
            "stackalloc", "static", "string", "struct", "switch",
            "this", "throw", "true", "try", "typeof", "uint", "ulong",
            "unsafe", "ushort", "using", "value*", "var*", "virtual",
            "unchecked", "void", "volatile", "where*", "while", "yield*" };
        
        public static void Main()
        {
            CountContextualKeywords();
        }

        private static void CountContextualKeywords()
        {
            int delegateInvocations = 0;
            Func<string, string> func =
                text =>
                {
                    delegateInvocations++;
                    return text;
                };

            IEnumerable<string> selection =
                from keyword in Keywords
                where keyword.Contains('*')
                select func(keyword); 


            Console.WriteLine(
                $"1. delegateInvocations={ delegateInvocations }");

            // Wywoanie metody Count powinno spowodowa wykonanie funkcji func raz
            // dla kadego pobranego elementu.
            Console.WriteLine(
                $"2. Kontekstowe sowa kluczowe Count={ selection.Count() }");

            Console.WriteLine(
                $"3. delegateInvocations={ delegateInvocations }");

            // Wywoanie metody Count powinno spowodowa wykonanie funkcji func raz
            // dla kadego pobranego elementu.
            Console.WriteLine(
                $"4. Kontekstowe sowa kluczowe Count={ selection.Count() }");

            Console.WriteLine(
                $"5. delegateInvocations={ delegateInvocations }");

            // Zapisanie wartoci w pamici podrcznej, tak by pniejsze wywoania Count 
            // nie skutkoway kolejnym uruchomieniem kwerendy.
            List<string> selectionCache = selection.ToList();

            Console.WriteLine(
                $"6. delegateInvocations={ delegateInvocations }");

            // Pobranie liczby elementw z kolekcji zapisanej w pamici podrcznej.
            Console.WriteLine(
                $"7. selectionCache count={ selectionCache.Count() }");

            Console.WriteLine(
                $"8. delegateInvocations={ delegateInvocations }");
        }
    }
}
