﻿namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter18.Listing18_06
{
    using System;
    using System.Diagnostics;
    using System.Threading.Tasks;
    using AddisonWesley.Michaelis.EssentialCSharp.Shared;

    public class Program
    {
        public static void Main()
        {
            // Aby zastosować bibliotekę TPL w wersjach starszych niż .NET 4.5, 
            // wywołaj metodę Task.Factory.StartNew<string>().
            Task<string> task =
                Task.Run<string>(
                    () => PiCalculator.Calculate(10));
            Task faultedTask = task.ContinueWith(
                (antecedentTask) =>
                {
                    Trace.Assert(antecedentTask.IsFaulted);
                    Console.WriteLine(
                        "Stan zadania: IsFaulted");
                },
                TaskContinuationOptions.OnlyOnFaulted);

            Task canceledTask = task.ContinueWith(
                (antecedentTask) =>
                {
                    Trace.Assert(antecedentTask.IsCanceled);
                    Console.WriteLine(
                        "Stan zadania: IsCanceled");
                },
                TaskContinuationOptions.OnlyOnCanceled);

            Task completedTask = task.ContinueWith(
                (antecedentTask) =>
                {
                    Trace.Assert(antecedentTask.IsCompleted);
                    Console.WriteLine(
                        "Stan zadania: IsCompleted");
                }, TaskContinuationOptions.
                        OnlyOnRanToCompletion);

            completedTask.Wait(); 

        }

    }
}





